/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class GoggleOverlayRenderer {
    public static final IIngameOverlay OVERLAY = GoggleOverlayRenderer::renderOverlay;
    private static final List<Supplier<Boolean>> customGogglePredicates = new LinkedList<Supplier<Boolean>>();
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.OUTLINER.getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(ForgeIngameGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Color colorBorderBot;
        boolean exceptionAdded;
        HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        ItemStack headSlot = mc.f_91074_.m_6844_(EquipmentSlot.HEAD);
        BlockEntity te = world.m_7702_(pos);
        hoverTicks = lastHovered == null || lastHovered.equals((Object)pos) ? ++hoverTicks : 0;
        lastHovered = pos;
        boolean wearingGoggles = AllItems.GOGGLES.isIn(headSlot);
        for (Supplier<Boolean> supplier : customGogglePredicates) {
            wearingGoggles |= supplier.get().booleanValue();
        }
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.f_91074_.m_6144_());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(TextComponent.f_131282_);
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.f_91074_.m_6144_());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            int n;
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_());
            int poles = 1;
            boolean bl = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((Level)world, pos, dir);
                poles += attachedPoles;
                n |= world.m_8055_(pos.m_5484_(dir, attachedPoles + 1)).m_60734_() instanceof MechanicalPistonBlock;
            }
            if (n == 0) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(TextComponent.f_131282_);
            }
            tooltip.add((Component)IHaveGoggleInformation.componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.goggles.pole_length", new Object[0])).m_7220_((Component)new TextComponent(" " + poles)));
        }
        if (tooltip.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.CLIENT;
        int posX = width / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 12.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color((Integer)cClient.overlayBackgroundColor.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BACKGROUND).scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color((Integer)cClient.overlayBorderColorTop.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, true).copy();
        Color color = colorBorderBot = useCustom != false ? new Color((Integer)cClient.overlayBorderColorBot.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, false).copy();
        if (fade < 1.0f) {
            poseStack.m_85837_((double)((1.0f - fade) * Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 4.0f), 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        RemovedGuiUtils.drawHoveringText(poseStack, tooltip, posX, posY, width, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.f_91062_);
        ItemStack item = AllItems.GOGGLES.asStack();
        ((RenderElement)GuiGameElement.of(item).at(posX + 10, posY - 16, 450.0f)).render(poseStack);
        poseStack.m_85849_();
    }

    public static void registerCustomGoggleCondition(Supplier<Boolean> condition) {
        customGogglePredicates.add(condition);
    }
}

