/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.LitBlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InWorldProcessing {
    private static final DamageSource FIRE_DAMAGE_SOURCE = new DamageSource("create.fan_fire").m_19386_().m_19383_();
    private static final DamageSource LAVA_DAMAGE_SOURCE = new DamageSource("create.fan_lava").m_19386_().m_19383_();
    private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    private static final SplashingWrapper SPLASHING_WRAPPER = new SplashingWrapper();
    private static final HauntingWrapper HAUNTING_WRAPPER = new HauntingWrapper();

    public static boolean canProcess(ItemEntity entity, Type type) {
        CompoundTag compound;
        if (entity.getPersistentData().m_128441_("CreateData") && (compound = entity.getPersistentData().m_128469_("CreateData")).m_128441_("Processing")) {
            CompoundTag processing = compound.m_128469_("Processing");
            if (Type.valueOf(processing.m_128461_("Type")) != type) {
                return type.canProcess(entity.m_32055_(), entity.f_19853_);
            }
            if (processing.m_128451_("Time") >= 0) {
                return true;
            }
            if (processing.m_128451_("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.m_32055_(), entity.f_19853_);
    }

    public static boolean isWashable(ItemStack stack, Level world) {
        SPLASHING_WRAPPER.m_6836_(0, stack);
        Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
        return recipe.isPresent();
    }

    public static boolean isHauntable(ItemStack stack, Level world) {
        HAUNTING_WRAPPER.m_6836_(0, stack);
        Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, world);
        return recipe.isPresent();
    }

    public static void applyProcessing(ItemEntity entity, Type type) {
        if (InWorldProcessing.decrementProcessingTime(entity, type) != 0) {
            return;
        }
        List<ItemStack> stacks = InWorldProcessing.process(entity.m_32055_(), type, entity.f_19853_);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.f_19853_.m_7967_((Entity)entityIn);
        }
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, Level world, Type type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.m_41613_() - 1) / 16 + 1;
            transported.processingTime = processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<ItemStack> stacks = InWorldProcessing.process(transported.stack, type, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.m_41777_();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static List<ItemStack> process(ItemStack stack, Type type, Level world) {
        if (type == Type.SPLASHING) {
            SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (Recipe)recipe.get());
            }
            return null;
        }
        if (type == Type.HAUNTING) {
            HAUNTING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (Recipe)recipe.get());
            }
            return null;
        }
        RECIPE_WRAPPER.m_6836_(0, stack);
        Optional smokingRecipe = world.m_7465_().m_44015_(RecipeType.f_44110_, (Container)RECIPE_WRAPPER, world);
        if (type == Type.BLASTING) {
            if (!smokingRecipe.isPresent()) {
                RECIPE_WRAPPER.m_6836_(0, stack);
                Optional smeltingRecipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)RECIPE_WRAPPER, world);
                if (smeltingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (Recipe)smeltingRecipe.get());
                }
                RECIPE_WRAPPER.m_6836_(0, stack);
                Optional blastingRecipe = world.m_7465_().m_44015_(RecipeType.f_44109_, (Container)RECIPE_WRAPPER, world);
                if (blastingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (Recipe)blastingRecipe.get());
                }
            }
            return Collections.emptyList();
        }
        if (type == Type.SMOKING && smokingRecipe.isPresent()) {
            return InWorldProcessing.applyRecipeOn(stack, (Recipe)smokingRecipe.get());
        }
        return null;
    }

    private static int decrementProcessingTime(ItemEntity entity, Type type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_("CreateData")) {
            nbt.m_128365_("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
            createData.m_128365_("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || Type.valueOf(processing.m_128461_("Type")) != type) {
            processing.m_128359_("Type", type.name());
            int timeModifierForStackSize = (entity.m_32055_().m_41613_() - 1) / 16 + 1;
            int processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            processing.m_128405_("Time", processingTime);
        }
        int value = processing.m_128451_("Time") - 1;
        processing.m_128405_("Time", value);
        return value;
    }

    public static void applyRecipeOn(ItemEntity entity, Recipe<?> recipe) {
        List<ItemStack> stacks = InWorldProcessing.applyRecipeOn(entity.m_32055_(), recipe);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.f_19853_.m_7967_((Entity)entityIn);
        }
    }

    public static List<ItemStack> applyRecipeOn(ItemStack stackIn, Recipe<?> recipe) {
        ArrayList<ItemStack> stacks;
        if (recipe instanceof ProcessingRecipe) {
            stacks = new ArrayList();
            for (int i = 0; i < stackIn.m_41613_(); ++i) {
                List<ItemStack> rollResults = ((ProcessingRecipe)recipe).rollResults();
                for (ItemStack stack : rollResults) {
                    for (ItemStack previouslyRolled : stacks) {
                        if (stack.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)previouslyRolled)) continue;
                        int amount = Math.min(previouslyRolled.m_41741_() - previouslyRolled.m_41613_(), stack.m_41613_());
                        previouslyRolled.m_41769_(amount);
                        stack.m_41774_(amount);
                    }
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
            }
        } else {
            ItemStack out = recipe.m_8043_().m_41777_();
            stacks = ItemHelper.multipliedOutput(stackIn, out);
        }
        return stacks;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        SPLASHING{

            @Override
            public void spawnParticlesForProcessing(Level level, Vec3 pos) {
                if (level.f_46441_.nextInt(8) != 0) {
                    return;
                }
                Vector3f color = new Color(22015).asVectorF();
                level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, pos.f_82479_ + (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            }

            @Override
            public void affectEntity(Entity entity, Level level) {
                if (level.f_46443_) {
                    return;
                }
                if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20528_ || entity.m_6095_() == EntityType.f_20551_) {
                    entity.m_6469_(DamageSource.f_19312_, 2.0f);
                }
                if (entity.m_6060_()) {
                    entity.m_20095_();
                    level.m_5594_(null, entity.m_142538_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.4f);
                }
            }

            @Override
            public boolean canProcess(ItemStack stack, Level level) {
                return InWorldProcessing.isWashable(stack, level);
            }
        }
        ,
        SMOKING{

            @Override
            public void spawnParticlesForProcessing(Level level, Vec3 pos) {
                if (level.f_46441_.nextInt(8) != 0) {
                    return;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0625, 0.0);
            }

            @Override
            public void affectEntity(Entity entity, Level level) {
                if (level.f_46443_) {
                    return;
                }
                if (!entity.m_5825_()) {
                    entity.m_20254_(2);
                    entity.m_6469_(FIRE_DAMAGE_SOURCE, 2.0f);
                }
            }

            @Override
            public boolean canProcess(ItemStack stack, Level level) {
                RECIPE_WRAPPER.m_6836_(0, stack);
                Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)RECIPE_WRAPPER, level);
                return recipe.isPresent();
            }
        }
        ,
        HAUNTING{

            @Override
            public void spawnParticlesForProcessing(Level level, Vec3 pos) {
                if (level.f_46441_.nextInt(8) != 0) {
                    return;
                }
                pos = pos.m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, level.f_46441_, 1.0f).m_82542_(1.0, (double)0.05f, 1.0).m_82541_().m_82490_((double)0.15f));
                level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
                if (level.f_46441_.nextInt(2) == 0) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0, 0.0);
                }
            }

            @Override
            public void affectEntity(Entity entity, Level level) {
                if (level.f_46443_) {
                    if (entity instanceof Horse) {
                        Vec3 p = entity.m_20318_(0.0f);
                        Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, level.f_46441_, 1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                        if (level.f_46441_.nextInt(3) == 0) {
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.nextFloat() - 0.5f) * 0.5f));
                        }
                    }
                    return;
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false));
                }
                if (entity instanceof Horse) {
                    Horse horse = (Horse)entity;
                    int progress = horse.getPersistentData().m_128451_("CreateHaunting");
                    if (progress < 100) {
                        if (progress % 10 == 0) {
                            level.m_5594_(null, entity.m_142538_(), SoundEvents.f_12404_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 100.0f);
                        }
                        horse.getPersistentData().m_128405_("CreateHaunting", progress + 1);
                        return;
                    }
                    level.m_5594_(null, entity.m_142538_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                    SkeletonHorse skeletonHorse = (SkeletonHorse)EntityType.f_20525_.m_20615_(level);
                    CompoundTag serializeNBT = horse.m_20240_(new CompoundTag());
                    serializeNBT.m_128473_("UUID");
                    if (!horse.m_30722_().m_41619_()) {
                        horse.m_19983_(horse.m_30722_());
                    }
                    skeletonHorse.deserializeNBT(serializeNBT);
                    skeletonHorse.m_146884_(horse.m_20318_(0.0f));
                    level.m_7967_((Entity)skeletonHorse);
                    horse.m_146870_();
                }
            }

            @Override
            public boolean canProcess(ItemStack stack, Level level) {
                return InWorldProcessing.isHauntable(stack, level);
            }
        }
        ,
        BLASTING{

            @Override
            public void spawnParticlesForProcessing(Level level, Vec3 pos) {
                if (level.f_46441_.nextInt(8) != 0) {
                    return;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0625, 0.0);
            }

            @Override
            public void affectEntity(Entity entity, Level level) {
                if (level.f_46443_) {
                    return;
                }
                if (!entity.m_5825_()) {
                    entity.m_20254_(10);
                    entity.m_6469_(LAVA_DAMAGE_SOURCE, 4.0f);
                }
            }

            @Override
            public boolean canProcess(ItemStack stack, Level level) {
                RECIPE_WRAPPER.m_6836_(0, stack);
                Optional smeltingRecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)RECIPE_WRAPPER, level);
                if (smeltingRecipe.isPresent()) {
                    return true;
                }
                RECIPE_WRAPPER.m_6836_(0, stack);
                Optional blastingRecipe = level.m_7465_().m_44015_(RecipeType.f_44109_, (Container)RECIPE_WRAPPER, level);
                if (blastingRecipe.isPresent()) {
                    return true;
                }
                return !stack.m_41720_().m_41475_();
            }
        }
        ,
        NONE{

            @Override
            public void spawnParticlesForProcessing(Level level, Vec3 pos) {
            }

            @Override
            public void affectEntity(Entity entity, Level level) {
            }

            @Override
            public boolean canProcess(ItemStack stack, Level level) {
                return false;
            }
        };


        public abstract boolean canProcess(ItemStack var1, Level var2);

        public abstract void spawnParticlesForProcessing(Level var1, Vec3 var2);

        public abstract void affectEntity(Entity var1, Level var2);

        public static Type byBlock(BlockGetter reader, BlockPos pos) {
            FluidState fluidState = reader.m_6425_(pos);
            if (fluidState.m_76152_() == Fluids.f_76193_ || fluidState.m_76152_() == Fluids.f_76192_) {
                return SPLASHING;
            }
            BlockState blockState = reader.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50084_ || block == Blocks.f_50684_ && blockState.m_61145_((Property)CampfireBlock.f_51227_).orElse(false).booleanValue() || AllBlocks.LIT_BLAZE_BURNER.has(blockState) && blockState.m_61145_(LitBlazeBurnerBlock.FLAME_TYPE).map(flame -> flame == LitBlazeBurnerBlock.FlameType.SOUL).orElse(false).booleanValue()) {
                return HAUNTING;
            }
            if (block == Blocks.f_50083_ || BlockTags.f_13087_.m_8110_((Object)block) && blockState.m_61145_((Property)CampfireBlock.f_51227_).orElse(false) != false || AllBlocks.LIT_BLAZE_BURNER.has(blockState) && blockState.m_61145_(LitBlazeBurnerBlock.FLAME_TYPE).map(flame -> flame == LitBlazeBurnerBlock.FlameType.REGULAR).orElse(false) != false || BlazeBurnerBlock.getHeatLevelOf(blockState) == BlazeBurnerBlock.HeatLevel.SMOULDERING) {
                return SMOKING;
            }
            if (block == Blocks.f_49991_ || BlazeBurnerBlock.getHeatLevelOf(blockState).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return BLASTING;
            }
            return NONE;
        }
    }

    public static class SplashingWrapper
    extends RecipeWrapper {
        public SplashingWrapper() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }

    public static class HauntingWrapper
    extends RecipeWrapper {
        public HauntingWrapper() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }
}

