/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.config.AllConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BackTankUtil {
    public static ItemStack get(LivingEntity entity) {
        for (ItemStack itemStack : entity.m_6168_()) {
            if (!AllItems.COPPER_BACKTANK.isIn(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAirRemaining(ItemStack backtank) {
        return BackTankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(ItemStack backtank) {
        CompoundTag tag = backtank.m_41784_();
        return Math.min(tag.m_128457_("Air"), (float)BackTankUtil.maxAir(backtank));
    }

    public static void consumeAir(ItemStack backtank, float i) {
        CompoundTag tag = backtank.m_41784_();
        tag.m_128350_("Air", Math.min(BackTankUtil.getAir(backtank) - i, (float)BackTankUtil.maxAir(backtank)));
        backtank.m_41751_(tag);
    }

    public static int maxAir(ItemStack backtank) {
        return BackTankUtil.maxAir(EnchantmentHelper.m_44843_((Enchantment)AllEnchantments.CAPACITY.get(), (ItemStack)backtank));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get() + (Integer)AllConfigs.SERVER.curiosities.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(LivingEntity entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return true;
        }
        ItemStack backtank = BackTankUtil.get(entity);
        if (backtank.m_41619_()) {
            return false;
        }
        if (!BackTankUtil.hasAirRemaining(backtank)) {
            return false;
        }
        float cost = (float)BackTankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BackTankUtil.consumeAir(backtank, cost);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isBarVisible(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BackTankUtil.hasAirRemaining(backtank)) {
            return stack.m_41768_();
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getBarWidth(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 13;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BackTankUtil.hasAirRemaining(backtank)) {
            return Math.round(13.0f - (float)stack.m_41773_() / (float)stack.m_41776_() * 13.0f);
        }
        return backtank.m_41720_().m_142158_(backtank);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getBarColor(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BackTankUtil.hasAirRemaining(backtank)) {
            return Mth.m_14169_((float)(Math.max(0.0f, 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtank.m_41720_().m_142159_(backtank);
    }
}

