/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.tools.ExtendoGripModel;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ExtendoGripItemRenderer
extends CustomRenderedItemModelRenderer<ExtendoGripModel> {
    private static final Vec3 rotationOffset = new Vec3(0.0, 0.5, 0.5);
    private static final Vec3 cogRotationOffset = new Vec3(0.0, 0.0625, 0.0);

    @Override
    protected void render(ItemStack stack, ExtendoGripModel model, PartialItemModelRenderer renderer, ItemTransforms.TransformType transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean rightHand;
        TransformStack stacker = TransformStack.cast((PoseStack)ms);
        float animation = 0.25f;
        boolean leftHand = transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        boolean bl = rightHand = transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
        if (leftHand || rightHand) {
            animation = Mth.m_14179_((float)AnimationTickHolder.getPartialTicks(), (float)ExtendoGripRenderHandler.lastMainHandAnimation, (float)ExtendoGripRenderHandler.mainHandAnimation);
        }
        animation = animation * animation * animation;
        float extensionAngle = Mth.m_14179_((float)animation, (float)24.0f, (float)156.0f);
        float halfAngle = extensionAngle / 2.0f;
        float oppositeAngle = 180.0f - extensionAngle;
        renderer.renderSolid(model.getOriginalModel(), light);
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0625, -0.4375);
        ms.m_85841_(1.0f, 1.0f, 1.0f + animation);
        ms.m_85836_();
        ((TransformStack)stacker.rotateX((double)(-halfAngle))).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("thin_short"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85837_(0.0, 0.34375, 0.0);
        ((TransformStack)stacker.rotateX((double)(-oppositeAngle))).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("wide_long"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85837_(0.0, 0.6875, 0.0);
        ((TransformStack)stacker.rotateX((double)oppositeAngle)).translate(rotationOffset);
        ms.m_85837_(0.0, 0.03125, 0.0);
        renderer.renderSolid(model.getPartial("thin_short"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85849_();
        ms.m_85836_();
        ((TransformStack)stacker.rotateX((double)(-180.0f + halfAngle))).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("wide_short"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85837_(0.0, 0.34375, 0.0);
        ((TransformStack)stacker.rotateX((double)oppositeAngle)).translate(rotationOffset);
        renderer.renderSolid(model.getPartial("thin_long"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85837_(0.0, 0.6875, 0.0);
        ((TransformStack)stacker.rotateX((double)(-oppositeAngle))).translate(rotationOffset);
        ms.m_85837_(0.0, 0.03125, 0.0);
        renderer.renderSolid(model.getPartial("wide_short"), light);
        stacker.translateBack(rotationOffset);
        ms.m_85837_(0.0, 0.34375, 0.0);
        ((TransformStack)stacker.rotateX((double)(180.0f - halfAngle))).rotateY(180.0);
        ms.m_85837_(0.0, 0.0, -0.25);
        ms.m_85841_(1.0f, 1.0f, 1.0f / (1.0f + animation));
        renderer.renderSolid(leftHand || rightHand ? ExtendoGripRenderHandler.pose.get() : AllBlockPartials.DEPLOYER_HAND_POINTING.get(), light);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        float angle = AnimationTickHolder.getRenderTime() * -2.0f;
        if (leftHand || rightHand) {
            angle += 360.0f * animation;
        }
        ((TransformStack)((TransformStack)stacker.translate(cogRotationOffset)).rotateZ((double)(angle %= 360.0f))).translateBack(cogRotationOffset);
        renderer.renderSolid(model.getPartial("cog"), light);
        ms.m_85849_();
    }

    @Override
    public ExtendoGripModel createModel(BakedModel originalModel) {
        return new ExtendoGripModel(originalModel);
    }
}

