/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.google.common.collect.Sets;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.utility.Lang;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public Object2IntMap<Item> gathered = new Object2IntArrayMap();
    public Object2IntMap<Item> required = new Object2IntArrayMap();
    public Object2IntMap<Item> damageRequired = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.requiredItems) {
            if (stack.usage == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack.item);
            }
            if (stack.usage != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack.item);
        }
    }

    private void putOrIncrement(Object2IntMap<Item> map, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_41852_) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.m_41613_());
        } else {
            map.put((Object)item, stack.m_41613_());
        }
    }

    public void collect(ItemStack stack) {
        Item item = stack.m_41720_();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            if (this.gathered.containsKey((Object)item)) {
                this.gathered.put((Object)item, this.gathered.getInt((Object)item) + stack.m_41613_());
            } else {
                this.gathered.put((Object)item, stack.m_41613_());
            }
        }
    }

    public ItemStack createItem() {
        TextComponent textComponent;
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag tag = book.m_41784_();
        ListTag pages = new ListTag();
        int itemsWritten = 0;
        if (this.blocksNotLoaded) {
            textComponent = new TextComponent("\n" + ChatFormatting.RED);
            textComponent = textComponent.m_7220_((Component)Lang.createTranslationTextComponent("materialChecklist.blocksNotLoaded", new Object[0]));
            pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = new TranslatableComponent(item1.m_5524_()).getString().toLowerCase(locale);
            String name2 = new TranslatableComponent(item2.m_5524_()).getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        textComponent = new TextComponent("");
        ArrayList<Item> completed = new ArrayList<Item>();
        for (Item item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.m_7220_((Component)new TextComponent("\n >>>").m_130940_(ChatFormatting.BLUE));
                pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
                textComponent = new TextComponent("");
            }
            ++itemsWritten;
            textComponent.m_7220_(this.entry(new ItemStack((ItemLike)item), amount, true));
        }
        for (Item item : completed) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.m_7220_((Component)new TextComponent("\n >>>").m_130940_(ChatFormatting.DARK_GREEN));
                pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
                textComponent = new TextComponent("");
            }
            ++itemsWritten;
            textComponent.m_7220_(this.entry(new ItemStack((ItemLike)item), this.getRequiredAmount(item), false));
        }
        pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
        tag.m_128365_("pages", (Tag)pages);
        tag.m_128359_("author", "Schematicannon");
        tag.m_128359_("title", ChatFormatting.BLUE + "Material Checklist");
        textComponent = Lang.createTranslationTextComponent("materialChecklist", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.FALSE));
        book.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)textComponent));
        book.m_41751_(tag);
        return book;
    }

    public int getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new ItemStack((ItemLike)item).m_41776_()));
        }
        return amount;
    }

    private Component entry(ItemStack item, int amount, boolean unfinished) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        TranslatableComponent tc = new TranslatableComponent(item.m_41778_());
        if (!unfinished) {
            tc.m_130946_(" \u2714");
        }
        tc.m_130940_(unfinished ? ChatFormatting.BLUE : ChatFormatting.DARK_GREEN);
        return tc.m_7220_((Component)new TextComponent("\n x" + amount).m_130940_(ChatFormatting.BLACK)).m_7220_((Component)new TextComponent(" | " + stacks + "\u25a4 +" + remainder + "\n").m_130940_(ChatFormatting.GRAY));
    }
}

