/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class SchematicTableTileEntity
extends SmartTileEntity
implements MenuProvider,
IInteractionChecker {
    public SchematicTableInventory inventory = new SchematicTableInventory();
    public boolean isUploading;
    public String uploadingSchematic = null;
    public float uploadingProgress = 0.0f;
    public boolean sendUpdate;

    public SchematicTableTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void sendToContainer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.m_58899_());
        buffer.m_130079_(this.m_5995_());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (compound.m_128441_("Uploading")) {
            this.isUploading = true;
            this.uploadingSchematic = compound.m_128461_("Schematic");
            this.uploadingProgress = compound.m_128457_("Progress");
        } else {
            this.isUploading = false;
            this.uploadingSchematic = null;
            this.uploadingProgress = 0.0f;
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        super.write(compound, clientPacket);
        if (clientPacket && this.isUploading) {
            compound.m_128379_("Uploading", true);
            compound.m_128359_("Schematic", this.uploadingSchematic);
            compound.m_128350_("Progress", this.uploadingProgress);
        }
    }

    @Override
    public void tick() {
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 6);
        }
    }

    public void startUpload(String schematic) {
        this.isUploading = true;
        this.uploadingProgress = 0.0f;
        this.uploadingSchematic = schematic;
        this.sendUpdate = true;
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
    }

    public void finishUpload() {
        this.isUploading = false;
        this.uploadingProgress = 0.0f;
        this.uploadingSchematic = null;
        this.sendUpdate = true;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return SchematicTableContainer.create(id, inv, this);
    }

    public Component m_5446_() {
        return Lang.translate("gui.schematicTable.title", new Object[0]);
    }

    @Override
    public boolean canPlayerUse(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public class SchematicTableInventory
    extends ItemStackHandler {
        public SchematicTableInventory() {
            super(2);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SchematicTableTileEntity.this.m_6596_();
        }
    }
}

