/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MinecartElement
extends AnimatedSceneElement {
    private Vec3 location;
    private LerpedFloat rotation;
    private AbstractMinecart entity;
    private MinecartConstructor constructor;
    private float initialRotation;

    public MinecartElement(Vec3 location, float rotation, MinecartConstructor constructor) {
        this.initialRotation = rotation;
        this.location = location.m_82520_(0.0, 0.0625, 0.0);
        this.constructor = constructor;
        this.rotation = LerpedFloat.angular().startWithValue(rotation);
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.entity.m_20343_(0.0, 0.0, 0.0);
        this.entity.f_19854_ = 0.0;
        this.entity.f_19855_ = 0.0;
        this.entity.f_19856_ = 0.0;
        this.entity.f_19790_ = 0.0;
        this.entity.f_19791_ = 0.0;
        this.entity.f_19792_ = 0.0;
        this.rotation.startWithValue(this.initialRotation);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.constructor.create(scene.getWorld(), 0.0, 0.0, 0.0);
        }
        ++this.entity.f_19797_;
        this.entity.m_6853_(true);
        this.entity.f_19854_ = this.entity.m_20185_();
        this.entity.f_19855_ = this.entity.m_20186_();
        this.entity.f_19856_ = this.entity.m_20189_();
        this.entity.f_19790_ = this.entity.m_20185_();
        this.entity.f_19791_ = this.entity.m_20186_();
        this.entity.f_19792_ = this.entity.m_20189_();
    }

    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        if (!immediate) {
            return;
        }
        this.entity.f_19854_ = position.f_82479_;
        this.entity.f_19855_ = position.f_82480_;
        this.entity.f_19856_ = position.f_82481_;
    }

    public void setRotation(float angle, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.rotation.setValue(angle);
        if (!immediate) {
            return;
        }
        this.rotation.startWithValue(angle);
    }

    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.m_20182_() : Vec3.f_82478_;
    }

    public Vec3 getRotation() {
        return new Vec3(0.0, (double)this.rotation.getValue(), 0.0);
    }

    @Override
    protected void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        if (this.entity == null) {
            this.entity = this.constructor.create(world, 0.0, 0.0, 0.0);
        }
        ms.m_85836_();
        ms.m_85837_(this.location.f_82479_, this.location.f_82480_, this.location.f_82481_);
        ms.m_85837_(Mth.m_14139_((double)pt, (double)this.entity.f_19854_, (double)this.entity.m_20185_()), Mth.m_14139_((double)pt, (double)this.entity.f_19855_, (double)this.entity.m_20186_()), Mth.m_14139_((double)pt, (double)this.entity.f_19856_, (double)this.entity.m_20189_()));
        TransformStack.cast((PoseStack)ms).rotateY((double)this.rotation.getValue(pt));
        entityrenderermanager.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.m_85849_();
    }

    public static interface MinecartConstructor {
        public AbstractMinecart create(Level var1, double var2, double var4, double var6);
    }
}

