/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public interface IPlacementHelper {
    public static final BlockState ID = new BlockState(Blocks.f_50016_, null, null);

    public Predicate<ItemStack> getItemPredicate();

    public Predicate<BlockState> getStatePredicate();

    public PlacementOffset getOffset(Player var1, Level var2, BlockState var3, BlockPos var4, BlockHitResult var5);

    default public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray, ItemStack heldItem) {
        PlacementOffset offset = this.getOffset(player, world, state, pos, ray);
        if (heldItem.m_41720_() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)heldItem.m_41720_();
            offset = offset.withGhostState(blockItem.m_40614_().m_49966_());
        }
        return offset;
    }

    default public void renderAt(BlockPos pos, BlockState state, BlockHitResult ray, PlacementOffset offset) {
        this.displayGhost(offset);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane) {
        IPlacementHelper.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane, double distanceFromCenter) {
        Vec3 direction = target.m_82546_(center).m_82541_();
        Vec3 facing = Vec3.m_82528_((Vec3i)arrowPlane.m_122436_());
        Vec3 start = center.m_82549_(direction);
        Vec3 offset = direction.m_82490_(distanceFromCenter - 1.0);
        Vec3 offsetA = direction.m_82537_(facing).m_82541_().m_82490_(0.25);
        Vec3 offsetB = facing.m_82537_(direction).m_82541_().m_82490_(0.25);
        Vec3 endA = center.m_82549_(direction.m_82490_(0.75)).m_82549_(offsetA);
        Vec3 endB = center.m_82549_(direction.m_82490_(0.75)).m_82549_(offsetB);
        CreateClient.OUTLINER.showLine("placementArrowA" + center + target, start.m_82549_(offset), endA.m_82549_(offset)).lineWidth(0.0625f);
        CreateClient.OUTLINER.showLine("placementArrowB" + center + target, start.m_82549_(offset), endB.m_82549_(offset)).lineWidth(0.0625f);
    }

    default public void displayGhost(PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        CreateClient.GHOST_BLOCKS.showGhostState(this, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vec3 hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, dir -> dir.m_122434_() == axis);
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vec3 hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.m_122434_() == axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, dir -> dir.m_122434_() != axis);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.m_122434_() != axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis first, Direction.Axis second) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, (Direction d) -> d.m_122434_() != second);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis first, Direction.Axis second, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, ((Predicate<Direction>)d -> d.m_122434_() != second).and(includeDirection));
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vec3 hit) {
        return IPlacementHelper.orderedByDistance(pos, hit, _$ -> true);
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vec3 hit, Predicate<Direction> includeDirection) {
        Vec3 centerToHit = hit.m_82546_(VecHelper.getCenterOf((Vec3i)pos));
        return Arrays.stream(Iterate.directions).filter(includeDirection).map(dir -> Pair.of(dir, Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82554_(centerToHit))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(Pair::getFirst).collect(Collectors.toList());
    }

    default public boolean matchesItem(ItemStack item) {
        return this.getItemPredicate().test(item);
    }

    default public boolean matchesState(BlockState state) {
        return this.getStatePredicate().test(state);
    }
}

