/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.util.NonNullConsumer;

public class LayerPattern {
    List<Layer> layers = new ArrayList<Layer>();

    public static Builder builder() {
        LayerPattern ore = new LayerPattern();
        return ore.new Builder();
    }

    public Layer rollNext(@Nullable Layer previous, Random random) {
        int totalWeight = 0;
        for (Layer layer : this.layers) {
            if (layer == previous) continue;
            totalWeight += layer.weight;
        }
        int rolled = random.nextInt(totalWeight);
        for (Layer layer : this.layers) {
            if (layer == previous || (rolled -= layer.weight) >= 0) continue;
            return layer;
        }
        return null;
    }

    class Builder {
        private boolean netherMode;

        Builder() {
        }

        public LayerPattern build() {
            return LayerPattern.this;
        }

        public Builder inNether() {
            this.netherMode = true;
            return this;
        }

        public Builder layer(NonNullConsumer<Layer.LayerBuilder> builder) {
            Layer layer = new Layer();
            Layer.LayerBuilder layerBuilder = layer.new Layer.LayerBuilder();
            layerBuilder.netherMode = this.netherMode;
            builder.accept((Object)layerBuilder);
            LayerPattern.this.layers.add(layerBuilder.build());
            return this;
        }
    }

    static class Layer {
        public List<List<OreConfiguration.TargetBlockState>> targets = new ArrayList<List<OreConfiguration.TargetBlockState>>();
        public int minSize = 1;
        public int maxSize = 1;
        public int weight = 1;

        public List<OreConfiguration.TargetBlockState> rollBlock(Random random) {
            if (this.targets.size() == 1) {
                return this.targets.get(0);
            }
            return this.targets.get(random.nextInt(this.targets.size()));
        }

        class LayerBuilder {
            private boolean netherMode;

            LayerBuilder() {
            }

            private Layer build() {
                return Layer.this;
            }

            public LayerBuilder block(NonNullSupplier<? extends Block> block) {
                return this.block(block.get());
            }

            public LayerBuilder passiveBlock() {
                return this.blocks(Blocks.f_50069_.m_49966_(), Blocks.f_152550_.m_49966_());
            }

            public LayerBuilder block(Block block) {
                if (this.netherMode) {
                    Layer.this.targets.add((List<OreConfiguration.TargetBlockState>)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)block.m_49966_())));
                    return this;
                }
                return this.blocks(block.m_49966_(), block.m_49966_());
            }

            public LayerBuilder blocks(Block block, Block deepblock) {
                return this.blocks(block.m_49966_(), deepblock.m_49966_());
            }

            public LayerBuilder blocks(Couple<NonNullSupplier<? extends Block>> blocksByDepth) {
                return this.blocks(((Block)((NonNullSupplier)blocksByDepth.getFirst()).get()).m_49966_(), ((Block)((NonNullSupplier)blocksByDepth.getSecond()).get()).m_49966_());
            }

            private LayerBuilder blocks(BlockState stone, BlockState deepslate) {
                Layer.this.targets.add((List<OreConfiguration.TargetBlockState>)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)stone), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)deepslate)));
                return this;
            }

            public LayerBuilder weight(int weight) {
                Layer.this.weight = weight;
                return this;
            }

            public LayerBuilder size(int min, int max) {
                Layer.this.minSize = min;
                Layer.this.maxSize = max;
                return this;
            }
        }
    }
}

