/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.client.model.pojo.BonesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.CubesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.Description;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class BedrockHumanoidModel
extends HumanoidModel<LivingEntity> {
    private final HashMap<String, BonesItem> indexBones = Maps.newHashMap();

    public BedrockHumanoidModel(ModelPart root) {
        super(root);
    }

    public LayerDefinition createLayer(BedrockModelPOJO pojo, CubeDeformation p_170682_, float p_170683_) {
        if (pojo.getFormatVersion().equals("1.10.0")) {
            return this.loadLegacyModel(pojo, p_170682_, p_170683_);
        }
        if (pojo.getFormatVersion().equals("1.12.0")) {
            return this.loadNewModel(pojo, p_170682_, p_170683_);
        }
        return null;
    }

    private LayerDefinition loadNewModel(BedrockModelPOJO pojo, CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        HashMap modelMap = Maps.newHashMap();
        assert (pojo.getGeometryModelNew() != null);
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            modelMap.put(bones.getName(), partdefinition.m_171597_(bones.getName()));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            PartDefinition model = (PartDefinition)modelMap.get(name);
            PartPose pose = null;
            pose = rotation != null ? PartPose.m_171423_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2), (float)this.convertRotation(rotation.get(0).floatValue()), (float)this.convertRotation(rotation.get(1).floatValue()), (float)this.convertRotation(rotation.get(2).floatValue())) : PartPose.m_171419_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2));
            CubeListBuilder cubeBuilder = CubeListBuilder.m_171558_();
            if (parent != null) {
                ((PartDefinition)modelMap.get(parent)).m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("head") || name.equalsIgnoreCase("bipedHead")) {
                head.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("hat")) {
                hat.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("body") || name.equalsIgnoreCase("bipedBody")) {
                body.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("armRight") || name.equalsIgnoreCase("bipedRightArm")) {
                right_arm.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("armLeft") || name.equalsIgnoreCase("bipedLeftArm")) {
                left_arm.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("legRight") || name.equalsIgnoreCase("bipedRightLeg")) {
                right_leg.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("legLeft") || name.equalsIgnoreCase("bipedLeftLeg")) {
                left_leg.m_171599_(name, cubeBuilder, pose);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    cubeBuilder.m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate));
                    continue;
                }
                String cubeName = name + "_cube_" + this.convertPivot(bones, cube, 0) + "_" + this.convertPivot(bones, cube, 1) + "_" + this.convertPivot(bones, cube, 2) + "_" + this.convertRotation(cubeRotation.get(0).floatValue()) + "_" + this.convertRotation(cubeRotation.get(1).floatValue()) + "_" + this.convertRotation(cubeRotation.get(2).floatValue()) + "_" + this.convertOrigin(bones, cube, 0) + "_" + this.convertOrigin(bones, cube, 1) + "_" + this.convertOrigin(bones, cube, 2) + "_" + size.get(0) + "_" + size.get(1) + "_" + size.get(2) + "_" + inflate;
                PartPose cubePose = PartPose.m_171423_((float)this.convertPivot(bones, cube, 0), (float)this.convertPivot(bones, cube, 1), (float)this.convertPivot(bones, cube, 2), (float)this.convertRotation(cubeRotation.get(0).floatValue()), (float)this.convertRotation(cubeRotation.get(1).floatValue()), (float)this.convertRotation(cubeRotation.get(2).floatValue()));
                model.m_171599_(cubeName, CubeListBuilder.m_171558_().m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate)), cubePose);
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)texWidth, (int)texHeight);
    }

    private LayerDefinition loadLegacyModel(BedrockModelPOJO pojo, CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        HashMap modelMap = Maps.newHashMap();
        assert (pojo.getGeometryModelLegacy() != null);
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            modelMap.put(bones.getName(), partdefinition.m_171597_(bones.getName()));
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            PartPose pose = null;
            pose = rotation != null ? PartPose.m_171423_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2), (float)this.convertRotation(rotation.get(0).floatValue()), (float)this.convertRotation(rotation.get(1).floatValue()), (float)this.convertRotation(rotation.get(2).floatValue())) : PartPose.m_171419_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2));
            CubeListBuilder cubeBuilder = CubeListBuilder.m_171558_();
            if (parent != null) {
                ((PartDefinition)modelMap.get(parent)).m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("head") || name.equalsIgnoreCase("bipedHead")) {
                head.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("hat")) {
                hat.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("body") || name.equalsIgnoreCase("bipedBody")) {
                body.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("armRight") || name.equalsIgnoreCase("bipedRightArm")) {
                right_arm.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("armLeft") || name.equalsIgnoreCase("bipedLeftArm")) {
                left_arm.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("legRight") || name.equalsIgnoreCase("bipedRightLeg")) {
                right_leg.m_171599_(name, cubeBuilder, pose);
            } else if (name.equalsIgnoreCase("legLeft") || name.equalsIgnoreCase("bipedLeftLeg")) {
                left_leg.m_171599_(name, cubeBuilder, pose);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                cubeBuilder.m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate));
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)texWidth, (int)texHeight);
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    private float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

