/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data.advancement;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.Logger;

public abstract class AbstractAdvancementProvider
extends AdvancementProvider {
    private final DataGenerator using_generator;

    public AbstractAdvancementProvider(DataGenerator gen, ExistingFileHelper fileHelperIn) {
        super(gen, fileHelperIn);
        this.using_generator = gen;
    }

    public abstract Logger getLogger();

    public abstract Gson getGSONInstance();

    public abstract Consumer<Consumer<Advancement>>[] getAdvancementTabs();

    public void m_6865_(HashCache cache) {
        Path path = this.using_generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path1 = AbstractAdvancementProvider.createNewPath(path, advancement);
            try {
                DataProvider.m_123920_((Gson)this.getGSONInstance(), (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                this.getLogger().error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        for (Consumer<Consumer<Advancement>> consumer1 : this.getAdvancementTabs()) {
            consumer1.accept(consumer);
        }
    }

    public static Path createNewPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }
}

