/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.utils;

import cn.mcmod_mmf.mmlib.Main;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.DataGenUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtil {
    public static final HashMap<ResourceLocation, BedrockModelPOJO> MODEL_MAP = Maps.newHashMap();
    private static ResourceManager manager = Minecraft.m_91087_().m_91098_();

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static void loadModel(ResourceLocation modelLocation) {
        try (InputStream input = manager.m_142591_(modelLocation).m_6679_();){
            BedrockModelPOJO pojo = (BedrockModelPOJO)DataGenUtil.gson.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (pojo.getFormatVersion().equals("1.10.0")) {
                if (pojo.getGeometryModelLegacy() != null) {
                    MODEL_MAP.put(modelLocation, pojo);
                    return;
                }
                Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
                return;
            }
            if (pojo.getFormatVersion().equals("1.12.0")) {
                if (pojo.getGeometryModelNew() != null) {
                    MODEL_MAP.put(modelLocation, pojo);
                    return;
                }
                Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
                return;
            }
            Main.getLogger().error("{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
        }
        catch (IOException ioe) {
            Main.getLogger().error("Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BedrockModelPOJO getModelPOJO(ResourceLocation modelLocation) {
        if (MODEL_MAP.containsKey(modelLocation)) {
            return MODEL_MAP.get(modelLocation);
        }
        return null;
    }
}

