/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkButton;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CheatInputHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.input.mouse.handlers.ProxyInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import org.jetbrains.annotations.Nullable;

public class BookmarkOverlay
implements IRecipeFocusSource,
ILeftAreaContent,
IBookmarkOverlay {
    private static final int BUTTON_SIZE = 20;
    private Rect2i parentArea = new Rect2i(0, 0, 0, 0);
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton bookmarkButton;
    private boolean hasRoom = false;
    private final BookmarkList bookmarkList;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;

    public BookmarkOverlay(BookmarkList bookmarkList, Textures textures, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig) {
        this.bookmarkList = bookmarkList;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.bookmarkButton = BookmarkButton.create(this, bookmarkList, textures, worldConfig);
        this.contents = contents;
        bookmarkList.addListener(() -> {
            worldConfig.setBookmarkEnabled(!bookmarkList.isEmpty());
            contents.updateLayout(false);
        });
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isBookmarkOverlayEnabled() && this.hasRoom && !this.bookmarkList.isEmpty();
    }

    public boolean hasRoom() {
        return this.hasRoom;
    }

    @Override
    public void updateBounds(Rect2i area, Set<Rect2i> guiExclusionAreas) {
        this.parentArea = area;
        this.hasRoom = this.updateBounds(guiExclusionAreas);
    }

    @Override
    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        this.bookmarkButton.draw(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        this.bookmarkButton.drawTooltips(poseStack, mouseX, mouseY);
    }

    private static int getMinWidth(IClientConfig clientConfig) {
        return Math.max(80, clientConfig.getMinColumns() * IngredientGrid.INGREDIENT_WIDTH);
    }

    public boolean updateBounds(Set<Rect2i> guiExclusionAreas) {
        Rect2i displayArea = this.parentArea;
        int minWidth = BookmarkOverlay.getMinWidth(this.clientConfig);
        if (displayArea.m_110090_() < minWidth) {
            return false;
        }
        Rect2i availableContentsArea = new Rect2i(displayArea.m_110085_(), displayArea.m_110086_(), displayArea.m_110090_(), displayArea.m_110091_() - 24);
        boolean contentsHasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        Rect2i contentsArea = this.contents.getArea();
        displayArea = new Rect2i(contentsArea.m_110085_(), displayArea.m_110086_(), contentsArea.m_110090_(), displayArea.m_110091_());
        this.bookmarkButton.updateBounds(new Rect2i(displayArea.m_110085_(), displayArea.m_110086_() + displayArea.m_110091_() - 20 - 2, 20, 20));
        this.contents.updateLayout(false);
        return contentsHasRoom;
    }

    @Override
    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        return this.getIngredientUnderMouse(MouseUtil.getX(), MouseUtil.getY()).map(IClickedIngredient::getValue);
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(ingredientType).map(ITypedIngredient::getIngredient).orElse(null);
        }
        return null;
    }

    @Override
    public IUserInputHandler createInputHandler() {
        IUserInputHandler bookmarkButtonInputHandler = this.bookmarkButton.createInputHandler();
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler(new CheatInputHandler(this, this.worldConfig, this.clientConfig), this.contents.createInputHandler(), bookmarkButtonInputHandler);
        return new ProxyInputHandler(() -> {
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            return bookmarkButtonInputHandler;
        });
    }
}

