/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.NullInputHandler;
import mezz.jei.input.mouse.handlers.ProxyInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import org.jetbrains.annotations.Nullable;

public class LeftAreaDispatcher
implements IRecipeFocusSource {
    private static final int BORDER_PADDING = 2;
    private final ILeftAreaContent contents;
    private final GuiScreenHelper guiScreenHelper;
    @Nullable
    private IGuiProperties guiProperties;
    private Rect2i displayArea = new Rect2i(0, 0, 0, 0);
    private boolean canShow = false;

    public LeftAreaDispatcher(GuiScreenHelper guiScreenHelper, ILeftAreaContent contents) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
    }

    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.canShow) {
            this.contents.drawScreen(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.canShow) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean forceUpdate) {
        this.canShow = false;
        IGuiProperties currentGuiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (currentGuiProperties == null) {
            this.guiProperties = null;
        } else {
            if (forceUpdate || !GuiProperties.areEqual(this.guiProperties, currentGuiProperties)) {
                Set<Rect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
                this.guiProperties = currentGuiProperties;
                this.makeDisplayArea(this.guiProperties);
                this.contents.updateBounds(this.displayArea, guiExclusionAreas);
            }
            this.canShow = true;
        }
    }

    private void makeDisplayArea(IGuiProperties guiProperties) {
        int x = 2;
        int y = 2;
        int width = guiProperties.getGuiLeft() - 2 - 2;
        int height = guiProperties.getScreenHeight() - 2 - 2;
        this.displayArea = new Rect2i(2, 2, width, height);
    }

    @Override
    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.canShow) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Optional.empty();
    }

    public IUserInputHandler createInputHandler() {
        IUserInputHandler contentsInputHandler = this.contents.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.canShow) {
                return contentsInputHandler;
            }
            return NullInputHandler.INSTANCE;
        });
    }
}

