/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.List;
import mezz.jei.config.KeyBindings;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.ICharTypedHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenEvent;

public class InputEventHandler {
    private final List<ICharTypedHandler> charTypedHandlers;
    private final CombinedInputHandler inputHandler;

    public InputEventHandler(List<ICharTypedHandler> charTypedHandlers, CombinedInputHandler inputHandler) {
        this.charTypedHandlers = charTypedHandlers;
        this.inputHandler = inputHandler;
    }

    public void register(RuntimeEventSubscriptions subscriptions) {
        subscriptions.register(ScreenEvent.InitScreenEvent.class, this::onInitGuiEvent);
        subscriptions.register(ScreenEvent.KeyboardKeyPressedEvent.Pre.class, this::onKeyboardKeyPressedEvent);
        subscriptions.register(ScreenEvent.KeyboardKeyPressedEvent.Post.class, this::onKeyboardKeyPressedEvent);
        subscriptions.register(ScreenEvent.KeyboardCharTypedEvent.Pre.class, this::onKeyboardCharTypedEvent);
        subscriptions.register(ScreenEvent.KeyboardCharTypedEvent.Post.class, this::onKeyboardCharTypedEvent);
        subscriptions.register(ScreenEvent.MouseClickedEvent.Pre.class, this::onGuiMouseClickedEvent);
        subscriptions.register(ScreenEvent.MouseReleasedEvent.Pre.class, this::onGuiMouseReleasedEvent);
        subscriptions.register(ScreenEvent.MouseScrollEvent.Pre.class, this::onGuiMouseScrollEvent);
    }

    public void onInitGuiEvent(ScreenEvent.InitScreenEvent event) {
        this.inputHandler.handleGuiChange();
    }

    public void onKeyboardKeyPressedEvent(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        Screen screen = event.getScreen();
        if (!InputEventHandler.isContainerTextFieldFocused(screen)) {
            UserInput input = UserInput.fromEvent((ScreenEvent.KeyboardKeyEvent)event);
            this.inputHandler.handleUserInput(screen, input).ifPresent(handler -> event.setCanceled(true));
        }
    }

    public void onKeyboardKeyPressedEvent(ScreenEvent.KeyboardKeyPressedEvent.Post event) {
        Screen screen = event.getScreen();
        if (InputEventHandler.isContainerTextFieldFocused(screen)) {
            UserInput input = UserInput.fromEvent((ScreenEvent.KeyboardKeyEvent)event);
            this.inputHandler.handleUserInput(screen, input).ifPresent(handler -> event.setCanceled(true));
        }
    }

    public void onKeyboardCharTypedEvent(ScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (!InputEventHandler.isContainerTextFieldFocused(event.getScreen()) && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onKeyboardCharTypedEvent(ScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (InputEventHandler.isContainerTextFieldFocused(event.getScreen()) && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiMouseClickedEvent(ScreenEvent.MouseClickedEvent.Pre event) {
        UserInput.fromEvent((ScreenEvent.MouseClickedEvent)event).ifPresent(input -> {
            Screen screen = event.getScreen();
            this.inputHandler.handleUserInput(screen, (UserInput)input).ifPresent(handled -> event.setCanceled(true));
            if (input.is(KeyBindings.leftClick)) {
                this.inputHandler.handleDragStart(screen, (UserInput)input).ifPresent(handled -> event.setCanceled(true));
            }
        });
    }

    public void onGuiMouseReleasedEvent(ScreenEvent.MouseReleasedEvent.Pre event) {
        UserInput.fromEvent((ScreenEvent.MouseReleasedEvent)event).ifPresent(input -> {
            Screen screen = event.getScreen();
            this.inputHandler.handleUserInput(screen, (UserInput)input).ifPresent(handled -> event.setCanceled(true));
            if (input.is(KeyBindings.leftClick)) {
                this.inputHandler.handleDragComplete(screen, (UserInput)input).ifPresent(handled -> event.setCanceled(true));
            }
        });
    }

    public void onGuiMouseScrollEvent(ScreenEvent.MouseScrollEvent.Pre event) {
        if (this.inputHandler.handleMouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.charTypedHandlers.stream().filter(ICharTypedHandler::hasKeyboardFocus).anyMatch(handler -> handler.onCharTyped(codePoint, modifiers));
    }

    private static boolean isContainerTextFieldFocused(Screen screen) {
        EditBox textField = ReflectionUtil.getFieldWithClass(screen, EditBox.class);
        return textField != null && textField.m_142518_() && textField.m_93696_();
    }
}

