/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import mezz.jei.config.IServerConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.ServerConfig;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdClient;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.util.CommandUtilServer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketCheatPermission
extends PacketJei {
    private final boolean hasPermission;

    public PacketCheatPermission(boolean hasPermission) {
        this.hasPermission = hasPermission;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdClient.CHEAT_PERMISSION;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeBoolean(this.hasPermission);
    }

    public static void readPacketData(FriendlyByteBuf buf, Player player, IWorldConfig worldConfig) {
        boolean hasPermission = buf.readBoolean();
        if (!hasPermission) {
            CommandUtilServer.writeChatMessage(player, "jei.chat.error.no.cheat.permission.1", ChatFormatting.RED);
            IServerConfig serverConfig = ServerConfig.getInstance();
            ArrayList<String> allowedCheatingMethods = new ArrayList<String>();
            if (serverConfig.isCheatModeEnabledForOp()) {
                allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.op");
            }
            if (serverConfig.isCheatModeEnabledForCreative()) {
                allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.creative");
            }
            if (serverConfig.isCheatModeEnabledForGive()) {
                allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.give");
            }
            if (allowedCheatingMethods.isEmpty()) {
                CommandUtilServer.writeChatMessage(player, "jei.chat.error.no.cheat.permission.disabled", ChatFormatting.RED);
            } else {
                CommandUtilServer.writeChatMessage(player, "jei.chat.error.no.cheat.permission.enabled", ChatFormatting.RED);
                for (String allowedCheatingMethod : allowedCheatingMethods) {
                    CommandUtilServer.writeChatMessage(player, allowedCheatingMethod, ChatFormatting.RED);
                }
            }
            worldConfig.setCheatItemsEnabled(false);
            player.m_6915_();
        }
    }
}

