/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.client.RenderProperties;

class InventoryEffectRendererGuiHandler<T extends AbstractContainerMenu>
implements IGuiContainerHandler<EffectRenderingInventoryScreen<T>> {
    InventoryEffectRendererGuiHandler() {
    }

    @Override
    public List<Rect2i> getGuiExtraAreas(EffectRenderingInventoryScreen<T> containerScreen) {
        Minecraft minecraft = containerScreen.getMinecraft();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Collections.emptyList();
        }
        Collection activePotionEffects = player.m_21220_();
        if (activePotionEffects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        int x = containerScreen.getGuiLeft() + containerScreen.getXSize() + 2;
        int y = containerScreen.getGuiTop();
        int availableSpace = containerScreen.f_96543_ - x;
        int width = availableSpace >= 120 ? 120 : 32;
        int height = 33;
        if (activePotionEffects.size() > 5) {
            height = 132 / (activePotionEffects.size() - 1);
        }
        for (MobEffectInstance potionEffect : activePotionEffects) {
            EffectRenderer effectRenderer = RenderProperties.getEffectRenderer((MobEffectInstance)potionEffect);
            if (!effectRenderer.shouldRender(potionEffect)) continue;
            areas.add(new Rect2i(x, y, width, height));
            y += height;
        }
        return areas;
    }
}

