/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import mezz.jei.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ExtendableRecipeCategoryHelper<T, W extends IRecipeCategoryExtension> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<RecipeHandler<? extends T, ? extends W>> recipeHandlers = new ArrayList<RecipeHandler<? extends T, ? extends W>>();
    private final Set<Class<? extends T>> handledClasses = new HashSet<Class<? extends T>>();
    private final Map<T, @Nullable W> cache = new IdentityHashMap<T, W>();
    private final Class<? extends T> expectedRecipeClass;

    public ExtendableRecipeCategoryHelper(Class<? extends T> expectedRecipeClass) {
        this.expectedRecipeClass = expectedRecipeClass;
    }

    public <R extends T> void addRecipeExtensionFactory(Class<? extends R> recipeClass, @Nullable Predicate<R> extensionFilter, Function<R, ? extends W> recipeExtensionFactory) {
        if (!this.expectedRecipeClass.isAssignableFrom(recipeClass)) {
            throw new IllegalArgumentException("Recipe handlers must handle a specific class. Needed: " + this.expectedRecipeClass + " Got: " + recipeClass);
        }
        if (this.handledClasses.contains(recipeClass)) {
            throw new IllegalArgumentException("A Recipe Extension Factory has already been registered for '" + recipeClass.getName());
        }
        this.handledClasses.add(recipeClass);
        this.recipeHandlers.add(new RecipeHandler<R, W>(recipeClass, extensionFilter, recipeExtensionFactory));
    }

    public <R extends T> W getRecipeExtension(R recipe) {
        return (W)((IRecipeCategoryExtension)this.getOptionalRecipeExtension(recipe).orElseThrow(() -> {
            String recipeName = ErrorUtil.getNameForRecipe(recipe);
            return new RuntimeException("Failed to create recipe extension for recipe: " + recipeName);
        }));
    }

    public <R extends T> Optional<W> getOptionalRecipeExtension(R recipe) {
        if (this.cache.containsKey(recipe)) {
            return Optional.ofNullable((IRecipeCategoryExtension)this.cache.get(recipe));
        }
        Optional<IRecipeCategoryExtension> result = this.getBestRecipeHandler(recipe).map(handler -> handler.apply(recipe));
        this.cache.put(recipe, result.orElse(null));
        return result;
    }

    private <R> Stream<RecipeHandler<R, W>> getRecipeHandlerStream(R recipe) {
        Class<?> recipeClass = recipe.getClass();
        return this.recipeHandlers.stream().filter(recipeHandler -> recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)).map(recipeHandler -> {
            RecipeHandler cast = recipeHandler;
            return cast;
        }).filter(recipeHandler -> recipeHandler.test(recipe));
    }

    private <R extends T> Optional<RecipeHandler<R, W>> getBestRecipeHandler(R recipe) {
        Class<?> recipeClass = recipe.getClass();
        ArrayList<Object> assignableHandlers = new ArrayList<Object>();
        List<RecipeHandler<R, W>> allHandlers = this.getRecipeHandlerStream(recipe).toList();
        for (RecipeHandler<R, W> recipeHandler : allHandlers) {
            Class<R> clazz = recipeHandler.getRecipeClass();
            if (clazz.equals(recipeClass)) {
                return Optional.of(recipeHandler);
            }
            assignableHandlers.removeIf(handler -> handler.getRecipeClass().isAssignableFrom(handlerRecipeClass));
            if (!assignableHandlers.stream().noneMatch(handler -> handlerRecipeClass.isAssignableFrom(handler.getRecipeClass()))) continue;
            assignableHandlers.add(recipeHandler);
        }
        if (assignableHandlers.isEmpty()) {
            return Optional.empty();
        }
        if (assignableHandlers.size() == 1) {
            return Optional.of((RecipeHandler)assignableHandlers.get(0));
        }
        Class<?> superClass = recipeClass;
        while (!Object.class.equals(superClass)) {
            superClass = superClass.getSuperclass();
            for (RecipeHandler recipeHandler : assignableHandlers) {
                if (!recipeHandler.getRecipeClass().equals(superClass)) continue;
                return Optional.of(recipeHandler);
            }
        }
        List<Class> assignableClasses = assignableHandlers.stream().map(RecipeHandler::getRecipeClass).toList();
        LOGGER.warn("Found multiple matching recipe handlers for {}: {}", recipeClass, assignableClasses);
        return Optional.of((RecipeHandler)assignableHandlers.get(0));
    }

    public static class RecipeHandler<T, W extends IRecipeCategoryExtension> {
        private final Class<? extends T> recipeClass;
        private final Function<T, W> factory;
        @Nullable
        private final Predicate<T> filter;

        public RecipeHandler(Class<? extends T> recipeClass, @Nullable Predicate<T> filter, Function<T, W> factory) {
            this.recipeClass = recipeClass;
            this.factory = factory;
            this.filter = filter;
        }

        public Class<? extends T> getRecipeClass() {
            return this.recipeClass;
        }

        public boolean test(T t) {
            if (this.filter == null) {
                return true;
            }
            return this.filter.test(t);
        }

        public W apply(T t) {
            return (W)((IRecipeCategoryExtension)this.factory.apply(t));
        }
    }
}

