/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.gui.recipes.builder.RecipeLayoutBuilder;
import mezz.jei.ingredients.IIngredientSupplier;
import mezz.jei.ingredients.IngredientVisibility;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.recipes.InternalRecipeManagerPlugin;
import mezz.jei.recipes.RecipeCatalystBuilder;
import mezz.jei.recipes.RecipeCategoryData;
import mezz.jei.recipes.RecipeCategoryDataMap;
import mezz.jei.recipes.RecipeManagerPluginSafeWrapper;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeManagerInternal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableList<IRecipeCategory<?>> recipeCategories;
    private final Set<ResourceLocation> hiddenRecipeCategoryUids = new HashSet<ResourceLocation>();
    private final IngredientVisibility ingredientVisibility;
    private final RegisteredIngredients registeredIngredients;
    @Nullable
    private ImmutableList<IRecipeCategory<?>> recipeCategoriesVisibleCache = null;
    private final RecipeCategoryDataMap recipeCategoriesDataMap;
    private final Comparator<IRecipeCategory<?>> recipeCategoryComparator;
    private final EnumMap<RecipeIngredientRole, RecipeMap> recipeMaps;
    private final List<RecipeManagerPluginSafeWrapper> plugins = new ArrayList<RecipeManagerPluginSafeWrapper>();

    public RecipeManagerInternal(ImmutableList<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<ResourceLocation, ITypedIngredient<?>> recipeCatalysts, RegisteredIngredients registeredIngredients, ImmutableList<IRecipeManagerPlugin> plugins, RecipeCategorySortingConfig recipeCategorySortingConfig, IngredientVisibility ingredientVisibility) {
        this.registeredIngredients = registeredIngredients;
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        this.ingredientVisibility = ingredientVisibility;
        List<ResourceLocation> recipeCategoryResourceLocations = recipeCategories.stream().map(IRecipeCategory::getUid).toList();
        Comparator<ResourceLocation> recipeCategoryUidComparator = recipeCategorySortingConfig.getComparator(recipeCategoryResourceLocations);
        this.recipeMaps = new EnumMap(RecipeIngredientRole.class);
        for (RecipeIngredientRole role : RecipeIngredientRole.values()) {
            RecipeMap recipeMap = new RecipeMap(recipeCategoryUidComparator, registeredIngredients, role);
            this.recipeMaps.put(role, recipeMap);
        }
        this.recipeCategoryComparator = Comparator.comparing(IRecipeCategory::getUid, recipeCategoryUidComparator);
        this.recipeCategories = ImmutableList.sortedCopyOf(this.recipeCategoryComparator, recipeCategories);
        RecipeCatalystBuilder recipeCatalystBuilder = new RecipeCatalystBuilder(registeredIngredients, this.recipeMaps.get((Object)RecipeIngredientRole.CATALYST));
        for (IRecipeCategory recipeCategory : recipeCategories) {
            ResourceLocation recipeCategoryUid = recipeCategory.getUid();
            if (!recipeCatalysts.containsKey((Object)recipeCategoryUid)) continue;
            ImmutableList catalysts = recipeCatalysts.get((Object)recipeCategoryUid);
            recipeCatalystBuilder.addCategoryCatalysts(recipeCategory, (List<ITypedIngredient<?>>)catalysts);
        }
        ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsMap = recipeCatalystBuilder.buildRecipeCategoryCatalysts();
        this.recipeCategoriesDataMap = new RecipeCategoryDataMap((List<IRecipeCategory<?>>)recipeCategories, recipeCategoryCatalystsMap);
        InternalRecipeManagerPlugin internalRecipeManagerPlugin = new InternalRecipeManagerPlugin(registeredIngredients, this.recipeCategoriesDataMap, this.recipeMaps);
        this.plugins.add(new RecipeManagerPluginSafeWrapper(internalRecipeManagerPlugin));
        for (IRecipeManagerPlugin plugin : plugins) {
            this.plugins.add(new RecipeManagerPluginSafeWrapper(plugin));
        }
    }

    public <T> void addRecipes(Collection<T> recipes, ResourceLocation recipeCategoryUid) {
        LOGGER.debug("Loading recipes: " + recipeCategoryUid);
        RecipeCategoryData<Collection<Object>> recipeCategoryData = this.recipeCategoriesDataMap.get(recipes, recipeCategoryUid);
        IRecipeCategory recipeCategory = recipeCategoryData.getRecipeCategory();
        Set hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        List<Object> addedRecipes = recipes.stream().filter(recipe -> {
            if (hiddenRecipes.contains(recipe) || !recipeCategory.isHandled((Collection)recipe)) {
                return false;
            }
            IIngredientSupplier ingredientSupplier = RecipeManagerInternal.getIngredientSupplier(recipe, recipeCategory, this.registeredIngredients);
            if (ingredientSupplier == null) {
                return false;
            }
            return this.addRecipe(recipe, recipeCategory, ingredientSupplier);
        }).toList();
        if (!addedRecipes.isEmpty()) {
            recipeCategoryData.addRecipes(addedRecipes);
            this.recipeCategoriesVisibleCache = null;
        }
    }

    @Nullable
    public static <T> IIngredientSupplier getIngredientSupplier(T recipe, IRecipeCategory<T> recipeCategory, RegisteredIngredients registeredIngredients) {
        String recipeName;
        try {
            RecipeLayoutBuilder builder = new RecipeLayoutBuilder(registeredIngredients, 0);
            recipeCategory.setRecipe((IRecipeLayoutBuilder)builder, recipe, FocusGroup.EMPTY);
            if (builder.isUsed()) {
                return builder;
            }
        }
        catch (LinkageError | RuntimeException e) {
            recipeName = ErrorUtil.getNameForRecipe(recipe);
            LOGGER.error("Found a broken recipe, failed to setRecipe with RecipeLayoutBuilder: {}\n", (Object)recipeName, (Object)e);
        }
        try {
            Ingredients ingredients = new Ingredients();
            recipeCategory.setIngredients(recipe, ingredients);
            return ingredients;
        }
        catch (LinkageError | RuntimeException e) {
            recipeName = ErrorUtil.getNameForRecipe(recipe);
            LOGGER.error("Found a broken recipe, failed to set Ingredients: {}\n", (Object)recipeName, (Object)e);
            return null;
        }
    }

    private <T> boolean addRecipe(T recipe, IRecipeCategory<T> recipeCategory, IIngredientSupplier ingredientSupplier) {
        try {
            for (RecipeMap recipeMap : this.recipeMaps.values()) {
                recipeMap.addRecipe(recipe, recipeCategory, ingredientSupplier);
            }
            return true;
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeCategory);
            LOGGER.error("Found a broken recipe, failed to addRecipe: {}\n", (Object)recipeInfo, (Object)e);
            return false;
        }
    }

    private boolean isCategoryHidden(IRecipeCategory<?> recipeCategory, IFocusGroup focuses) {
        if (this.hiddenRecipeCategoryUids.contains(recipeCategory.getUid())) {
            return true;
        }
        if (this.getRecipeCatalystStream(recipeCategory, true).findAny().isPresent() && this.getRecipeCatalystStream(recipeCategory, false).findAny().isEmpty()) {
            return true;
        }
        Stream<?> visibleRecipes = this.getRecipesStream(recipeCategory, focuses, false);
        return visibleRecipes.findAny().isEmpty();
    }

    public Stream<IRecipeCategory<?>> getRecipeCategoriesStream(Collection<ResourceLocation> recipeCategoryUids, IFocusGroup focuses, boolean includeHidden) {
        if (recipeCategoryUids.isEmpty() && focuses.isEmpty() && !includeHidden) {
            if (this.recipeCategoriesVisibleCache == null) {
                this.recipeCategoriesVisibleCache = (ImmutableList)this.getRecipeCategoriesStreamUncached(recipeCategoryUids, focuses, includeHidden).collect(ImmutableList.toImmutableList());
            }
            return this.recipeCategoriesVisibleCache.stream();
        }
        return this.getRecipeCategoriesStreamUncached(recipeCategoryUids, focuses, includeHidden);
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesStreamUncached(Collection<ResourceLocation> recipeCategoryUids, IFocusGroup focuses, boolean includeHidden) {
        Stream<IRecipeCategory> categoryStream;
        if (focuses.isEmpty()) {
            categoryStream = recipeCategoryUids.isEmpty() ? this.recipeCategories.stream() : recipeCategoryUids.stream().distinct().map(this.recipeCategoriesDataMap::get).map(RecipeCategoryData::getRecipeCategory);
        } else {
            Stream uidStream = this.plugins.stream().flatMap(p -> RecipeManagerInternal.getPluginRecipeCategoryUidStream(p, focuses)).distinct();
            if (!recipeCategoryUids.isEmpty()) {
                uidStream = uidStream.filter(recipeCategoryUids::contains);
            }
            categoryStream = uidStream.map(this.recipeCategoriesDataMap::get).map(RecipeCategoryData::getRecipeCategory);
        }
        if (!includeHidden) {
            categoryStream = categoryStream.filter(c -> !this.isCategoryHidden((IRecipeCategory<?>)c, focuses));
        }
        return categoryStream.sorted(this.recipeCategoryComparator);
    }

    public <T> Stream<T> getRecipesStream(IRecipeCategory<T> recipeCategory, IFocusGroup focuses, boolean includeHidden) {
        Stream<Object> recipes = this.plugins.stream().flatMap(p -> RecipeManagerInternal.getPluginRecipeStream(p, recipeCategory, focuses));
        if (!includeHidden) {
            RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
            Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
            Predicate<Object> notHidden = ((Predicate<Object>)hiddenRecipes::contains).negate();
            recipes = recipes.filter(notHidden);
        }
        return recipes;
    }

    private static Stream<ResourceLocation> getPluginRecipeCategoryUidStream(IRecipeManagerPlugin plugin, IFocusGroup focuses) {
        List<IFocus<?>> allFocuses = focuses.getAllFocuses();
        return allFocuses.stream().flatMap(focus -> {
            List<ResourceLocation> recipeCategoryUids = plugin.getRecipeCategoryUids(focus);
            return recipeCategoryUids.stream();
        });
    }

    private static <T> Stream<T> getPluginRecipeStream(IRecipeManagerPlugin plugin, IRecipeCategory<T> recipeCategory, IFocusGroup focuses) {
        if (!focuses.isEmpty()) {
            List<IFocus<?>> allFocuses = focuses.getAllFocuses();
            return allFocuses.stream().flatMap(focus -> {
                List recipes = plugin.getRecipes(recipeCategory, focus);
                return recipes.stream();
            });
        }
        return plugin.getRecipes(recipeCategory).stream();
    }

    public <T> Stream<ITypedIngredient<?>> getRecipeCatalystStream(IRecipeCategory<T> recipeCategory, boolean includeHidden) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
        ImmutableList<ITypedIngredient<?>> catalysts = recipeCategoryData.getRecipeCategoryCatalysts();
        if (includeHidden) {
            return catalysts.stream();
        }
        return catalysts.stream().filter(this.ingredientVisibility::isIngredientVisible);
    }

    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.add(recipe);
        this.recipeCategoriesVisibleCache = null;
    }

    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.remove(recipe);
        this.recipeCategoriesVisibleCache = null;
    }

    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenRecipeCategoryUids.add(recipeCategoryUid);
        this.recipeCategoriesVisibleCache = null;
    }

    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.recipeCategoriesDataMap.validate(recipeCategoryUid);
        this.hiddenRecipeCategoryUids.remove(recipeCategoryUid);
        this.recipeCategoriesVisibleCache = null;
    }
}

