/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.search.CombinedSearchables;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.PrefixInfos;
import mezz.jei.search.PrefixedSearchable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementSearch
implements IElementSearch {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PrefixInfo, PrefixedSearchable> prefixedSearchables = new IdentityHashMap<PrefixInfo, PrefixedSearchable>();
    private final CombinedSearchables<IListElementInfo<?>> combinedSearchables = new CombinedSearchables();

    public ElementSearch(PrefixInfos prefixInfos) {
        for (PrefixInfo prefixInfo : prefixInfos.allPrefixInfos()) {
            ISearchStorage<IListElementInfo<?>> storage = prefixInfo.createStorage();
            PrefixedSearchable prefixedSearchable = new PrefixedSearchable(storage, prefixInfo);
            this.prefixedSearchables.put(prefixInfo, prefixedSearchable);
            this.combinedSearchables.addSearchable(prefixedSearchable);
        }
    }

    @Override
    public Set<IListElementInfo<?>> getSearchResults(PrefixInfos.TokenInfo tokenInfo) {
        String token = tokenInfo.token();
        if (token.isEmpty()) {
            return Set.of();
        }
        Set<IListElementInfo<?>> results = Collections.newSetFromMap(new IdentityHashMap());
        PrefixInfo prefixInfo = tokenInfo.prefixInfo();
        if (prefixInfo == PrefixInfo.NO_PREFIX) {
            this.combinedSearchables.getSearchResults(token, results);
            return results;
        }
        ISearchable searchable = this.prefixedSearchables.get(prefixInfo);
        if (searchable == null || searchable.getMode() == SearchMode.DISABLED) {
            this.combinedSearchables.getSearchResults(token, results);
            return results;
        }
        searchable.getSearchResults(token, results);
        return results;
    }

    @Override
    public void add(IListElementInfo<?> info) {
        for (PrefixedSearchable prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchable.getStrings(info);
            ISearchStorage<IListElementInfo<?>> searchable = prefixedSearchable.getSearchStorage();
            for (String string : strings) {
                searchable.put(string, info);
            }
        }
    }

    public Set<IListElementInfo<?>> getAllIngredients() {
        Set<IListElementInfo<?>> results = Collections.newSetFromMap(new IdentityHashMap());
        this.prefixedSearchables.get(PrefixInfo.NO_PREFIX).getAllElements(results);
        return results;
    }

    @Override
    public void logStatistics() {
        for (Map.Entry<PrefixInfo, PrefixedSearchable> e : this.prefixedSearchables.entrySet()) {
            PrefixInfo prefixInfo = e.getKey();
            if (prefixInfo.getMode() == SearchMode.DISABLED) continue;
            ISearchStorage<IListElementInfo<?>> storage = e.getValue().getSearchStorage();
            LOGGER.info("ElementSearch {} Storage Stats: {}", (Object)prefixInfo, (Object)storage.statistics());
        }
    }
}

