/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search.suffixtree;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import mezz.jei.search.suffixtree.Edge;
import mezz.jei.util.SubString;
import org.jetbrains.annotations.Nullable;

class Node<T> {
    private Collection<T> data;
    private Char2ObjectMap<Edge<T>> edges = Char2ObjectMaps.emptyMap();
    @Nullable
    private Node<T> suffix = null;

    Node() {
        this.data = List.of();
    }

    public void getData(Set<T> results) {
        results.addAll(this.data);
        for (Edge edge : this.edges.values()) {
            Node<T> dest = edge.getDest();
            dest.getData(results);
        }
    }

    void addRef(T value) {
        if (this.contains(value)) {
            return;
        }
        this.addValue(value);
        Node<T> iter = this.suffix;
        while (iter != null && !iter.contains(value)) {
            iter.addValue(value);
            iter = iter.suffix;
        }
    }

    protected boolean contains(T value) {
        return this.data.contains(value);
    }

    void addEdge(Edge<T> edge) {
        char firstChar = edge.charAt(0);
        switch (this.edges.size()) {
            case 0: {
                this.edges = Char2ObjectMaps.singleton((char)firstChar, edge);
                break;
            }
            case 1: {
                Char2ObjectOpenHashMap newEdges = new Char2ObjectOpenHashMap(this.edges);
                newEdges.put(firstChar, edge);
                this.edges = newEdges;
                break;
            }
            default: {
                this.edges.put(firstChar, edge);
            }
        }
    }

    @Nullable
    Edge<T> getEdge(char ch) {
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Edge<T> getEdge(SubString string) {
        if (string.isEmpty()) {
            return null;
        }
        char ch = string.charAt(0);
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Node<T> getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node<T> suffix) {
        this.suffix = suffix;
    }

    protected void addValue(T value) {
        switch (this.data.size()) {
            case 0: {
                this.data = List.of(value);
                break;
            }
            case 1: {
                this.data = List.of(this.data.iterator().next(), value);
                break;
            }
            case 2: {
                ArrayList<T> newData = new ArrayList<T>(4);
                newData.addAll(this.data);
                newData.add(value);
                this.data = newData;
                break;
            }
            case 16: {
                Set newData = Collections.newSetFromMap(new IdentityHashMap());
                newData.addAll(this.data);
                newData.add(value);
                this.data = newData;
                break;
            }
            default: {
                this.data.add(value);
            }
        }
    }

    public String toString() {
        return "Node: size:" + this.data.size() + " Edges: " + this.edges;
    }

    public IntSummaryStatistics nodeSizeStats() {
        return this.nodeSizes().summaryStatistics();
    }

    private IntStream nodeSizes() {
        return IntStream.concat(IntStream.of(this.data.size()), this.edges.values().stream().flatMapToInt(e -> e.getDest().nodeSizes()));
    }

    public String nodeEdgeStats() {
        IntSummaryStatistics edgeCounts = this.nodeEdgeCounts().summaryStatistics();
        IntSummaryStatistics edgeLengths = this.nodeEdgeLengths().summaryStatistics();
        return "Edge counts: " + edgeCounts + "\nEdge lengths: " + edgeLengths;
    }

    private IntStream nodeEdgeCounts() {
        return IntStream.concat(IntStream.of(this.edges.size()), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeCounts));
    }

    private IntStream nodeEdgeLengths() {
        return IntStream.concat(this.edges.values().stream().mapToInt(SubString::length), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeLengths));
    }

    public void printTree(PrintWriter out, boolean includeSuffixLinks) {
        out.println("digraph {");
        out.println("\trankdir = LR;");
        out.println("\tordering = out;");
        out.println("\tedge [arrowsize=0.4,fontsize=10]");
        out.println("\t" + Node.nodeId(this) + " [label=\"\",style=filled,fillcolor=lightgrey,shape=circle,width=.1,height=.1];");
        out.println("//------leaves------");
        this.printLeaves(out);
        out.println("//------internal nodes------");
        this.printInternalNodes(this, out);
        out.println("//------edges------");
        this.printEdges(out);
        if (includeSuffixLinks) {
            out.println("//------suffix links------");
            this.printSLinks(out);
        }
        out.println("}");
    }

    private void printLeaves(PrintWriter out) {
        if (this.edges.size() == 0) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + this.data + "\",shape=point,style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        } else {
            for (Edge edge : this.edges.values()) {
                edge.getDest().printLeaves(out);
            }
        }
    }

    private void printInternalNodes(Node<T> root, PrintWriter out) {
        if (this != root && this.edges.size() > 0) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + this.data + "\",style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        }
        for (Edge edge : this.edges.values()) {
            edge.getDest().printInternalNodes(root, out);
        }
    }

    private void printEdges(PrintWriter out) {
        for (Edge edge : this.edges.values()) {
            Node child = edge.getDest();
            out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(child) + " [label=\"" + edge.commit() + "\",weight=10]");
            child.printEdges(out);
        }
    }

    private void printSLinks(PrintWriter out) {
        if (this.suffix != null) {
            out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(this.suffix) + " [label=\"\",weight=0,style=dotted]");
        }
        for (Edge edge : this.edges.values()) {
            edge.getDest().printSLinks(out);
        }
    }

    private static <T> String nodeId(Node<T> node) {
        return "node" + Integer.toHexString(node.hashCode()).toUpperCase();
    }
}

