/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public abstract class BaseContainerScreen<T extends BaseContainer>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    private final List<Widget> widgets = new LinkedList<Widget>();
    private final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();
    protected final T container;
    private boolean drawSlots = true;

    public BaseContainerScreen(T screenContainer, Component title) {
        super(screenContainer, ((BaseContainer)((Object)screenContainer)).player.m_150109_(), title);
        this.container = screenContainer;
    }

    protected abstract int sizeX();

    protected abstract int sizeY();

    protected int left() {
        return (this.f_96543_ - this.sizeX()) / 2;
    }

    protected int top() {
        return (this.f_96544_ - this.sizeY()) / 2;
    }

    public int getXSize() {
        return this.sizeX();
    }

    public int getYSize() {
        return this.sizeY();
    }

    public int getGuiLeft() {
        return this.left();
    }

    public int getGuiTop() {
        return this.top();
    }

    protected void setDrawSlots(boolean drawSlots) {
        this.drawSlots = drawSlots;
    }

    public void m_7856_() {
        this.f_97726_ = this.sizeX();
        this.f_97727_ = this.sizeY();
        super.m_7856_();
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    protected void m_181908_() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ITickableWidget)) continue;
            ((ITickableWidget)((Object)widget)).tick();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        poseStack.m_85837_((double)this.left(), (double)this.top(), 0.0);
        this.renderBackground(poseStack, mouseX - this.left(), mouseY - this.top());
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).f_38839_) {
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(poseStack, slot.f_40220_ - 1, slot.f_40221_ - 1, 18.0f, 18.0f);
            }
        }
        poseStack.m_85837_((double)(-this.left()), (double)(-this.top()), 0.0);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        poseStack.m_85837_((double)this.left(), (double)this.top(), 0.0);
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.m_93252_();
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX - this.left() > widget.x && mouseX - this.left() < widget.x + widget.width && mouseY - this.top() > widget.y && mouseY - this.top() < widget.y + widget.height;
            widget.render(poseStack, mouseX - this.left(), mouseY - this.top(), partialTicks);
            widget.narrate();
        }
        this.renderForeground(poseStack, mouseX - this.left(), mouseY - this.top());
        for (Widget widget : this.widgets) {
            Component text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.m_96602_(poseStack, text, mouseX - this.left(), mouseY - this.top());
        }
        poseStack.m_85837_((double)(-this.left()), (double)(-this.top()), 0.0);
        super.m_7025_(poseStack, mouseX, mouseY);
        this.renderTooltips(poseStack, mouseX - this.left(), mouseY - this.top());
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    protected void renderBackground(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawScreenBackground(poseStack);
    }

    protected void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        ScreenUtils.drawString(poseStack, this.f_96547_, this.f_96539_, 8.0f, 7.0f, 0x404040);
    }

    protected void renderTooltips(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(PoseStack poseStack, float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(poseStack, x, y, width, height);
    }

    protected void drawScreenBackground(PoseStack poseStack) {
        ScreenUtils.drawScreenBackground(poseStack, 0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        return super.m_6375_(mouseX += (double)this.left(), mouseY += (double)this.top(), button);
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        return super.m_6348_(mouseX += (double)this.left(), mouseY += (double)this.top(), button);
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return super.m_6050_(mouseX += (double)this.left(), mouseY += (double)this.top(), delta);
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.keyPressed(keyCode)) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        return handled;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.charTyped(codePoint);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }
}

