/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;

public class DynamicResourcePack
implements PackResources {
    private final String packName;
    private Map<DynamicResourceKey, Supplier<InputStream>> dynamicResourceMap = new HashMap<DynamicResourceKey, Supplier<InputStream>>();

    public DynamicResourcePack(String packName) {
        this.packName = packName;
    }

    public void clear() {
        this.dynamicResourceMap.clear();
    }

    public boolean removeResource(PackType type, ResourceLocation location) {
        DynamicResourceKey key = new DynamicResourceKey(type.m_10305_(), location.m_135827_(), location.m_135815_());
        if (this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean registerResource(PackType type, ResourceLocation location, Supplier<InputStream> resourceSupplier) {
        return this.register(type.m_10305_(), location.m_135827_(), location.m_135815_(), resourceSupplier);
    }

    public boolean registerRootResource(String path, Supplier<InputStream> resourceSupplier) {
        return this.register("root", "", path, resourceSupplier);
    }

    private boolean register(String directory, String namespace, String path, Supplier<InputStream> resourceSupplier) {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (!this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.put(key, resourceSupplier);
            return true;
        }
        return false;
    }

    public InputStream m_5542_(String path) throws IOException {
        return this.getResource("root", "", path);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        return this.getResource(type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    private InputStream getResource(String directory, String namespace, String path) throws IOException {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (this.dynamicResourceMap.containsKey(key)) {
            return this.dynamicResourceMap.get(key).get();
        }
        throw new FileNotFoundException("Can't find dynamic resource " + path + ". Please ensure it has been registered.");
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        return this.dynamicResourceMap.entrySet().stream().filter(entry -> ((DynamicResourceKey)entry.getKey()).namespace.contentEquals(namespace)).filter(entry -> ((DynamicResourceKey)entry.getKey()).path.startsWith(path)).filter(entry -> ((DynamicResourceKey)entry.getKey()).type.contentEquals(type.m_10305_())).filter(entry -> filter.test(((DynamicResourceKey)entry.getKey()).path)).map(entry -> new ResourceLocation(namespace, ((DynamicResourceKey)entry.getKey()).path)).collect(Collectors.toList());
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return this.dynamicResourceMap.containsKey(new DynamicResourceKey(type.m_10305_(), location.m_135827_(), location.m_135815_()));
    }

    public Set<String> m_5698_(PackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DynamicResourceKey key : this.dynamicResourceMap.keySet()) {
            if (!type.m_10305_().contentEquals(key.type)) continue;
            namespaces.add(key.namespace);
        }
        return namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> p_10291_) throws IOException {
        return null;
    }

    public String m_8017_() {
        return this.packName;
    }

    public void close() {
    }

    private record DynamicResourceKey(String type, String namespace, String path) {
    }
}

