/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.aspect;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.apache.commons.lang3.tuple.Pair;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;

public class TetraEnchantmentHelper {
    private static final Map<ItemAspect, EnchantmentRules> aspectMap = HashBiMap.create();

    public static void registerMapping(ItemAspect aspect, @Nullable EnchantmentCategory category, String additions, String exclusions) {
        TetraEnchantmentHelper.registerMapping(aspect, new EnchantmentRules(category, additions, exclusions));
    }

    public static void registerMapping(ItemAspect aspect, EnchantmentRules rules) {
        aspectMap.put(aspect, rules);
    }

    public static boolean isApplicableForAspects(Enchantment enchantment, boolean fromTable, Map<ItemAspect, Integer> aspects) {
        int requiredLevel = fromTable ? 2 : 1;
        return aspects.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= requiredLevel).filter(entry -> aspectMap.containsKey(entry.getKey())).anyMatch(entry -> aspectMap.get(entry.getKey()).isApplicable(enchantment));
    }

    @Nullable
    public static EnchantmentCategory getEnchantmentCategory(ItemAspect aspect) {
        return TetraEnchantmentHelper.aspectMap.get((Object)aspect).category;
    }

    public static ItemStack removeAllEnchantments(ItemStack itemStack) {
        itemStack.m_41749_("Enchantments");
        itemStack.m_41749_("StoredEnchantments");
        itemStack.m_41749_("EnchantmentMapping");
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    public static ItemStack transferReplacementEnchantments(ItemStack original, ItemStack replacementStack) {
        Optional.ofNullable(original.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).filter(enchantments -> enchantments.size() > 0).ifPresent(enchantments -> {
            replacementStack.m_41784_().m_128365_("Enchantments", (Tag)enchantments.m_6426_());
            TetraEnchantmentHelper.mapEnchantments(replacementStack);
        });
        return replacementStack;
    }

    public static void applyEnchantment(ItemStack itemStack, String slot, Enchantment enchantment, int level) {
        itemStack.m_41663_(enchantment, level);
        TetraEnchantmentHelper.mapEnchantment(itemStack, slot, enchantment);
    }

    public static void mapEnchantment(ItemStack itemStack, String slot, Enchantment enchantment) {
        CompoundTag map = itemStack.m_41698_("EnchantmentMapping");
        map.m_128359_(Registry.f_122825_.m_7981_((Object)enchantment).toString(), slot);
    }

    public static void mapEnchantments(ItemStack itemStack) {
        CompoundTag mappings = itemStack.m_41698_("EnchantmentMapping");
        Map mapped = Optional.of(mappings).map(CompoundTag::m_128431_).stream().flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), arg_0 -> ((CompoundTag)mappings).m_128461_(arg_0)));
        Map<String, Integer> capacity = Arrays.stream(((IModularItem)itemStack.m_41720_()).getMajorModules(itemStack)).filter(Objects::nonNull).collect(Collectors.toMap(ItemModule::getSlot, module -> module.getMagicCapacity(itemStack)));
        List<Pair> unmapped = Optional.of(itemStack.m_41785_()).stream().flatMap(Collection::stream).map(nbt -> (CompoundTag)nbt).map(nbt -> Pair.of((Object)nbt.m_128461_("id"), (Object)nbt.m_128451_("lvl"))).filter(pair -> !mapped.containsKey(pair.getKey())).collect(Collectors.toList());
        ItemModuleMajor[] modules = ((IModularItem)itemStack.m_41720_()).getMajorModules(itemStack);
        unmapped.forEach(pair -> {
            Enchantment enchantment = Registry.f_122825_.m_6612_(new ResourceLocation((String)pair.getKey())).orElse(null);
            if (enchantment != null) {
                Arrays.stream(modules).filter(Objects::nonNull).filter(module -> module.acceptsEnchantment(itemStack, enchantment, false)).map(ItemModule::getSlot).max(Comparator.comparing(slot -> capacity.getOrDefault(slot, 0))).ifPresent(slot -> {
                    TetraEnchantmentHelper.mapEnchantment(itemStack, slot, enchantment);
                    int cost = TetraEnchantmentHelper.getEnchantmentCapacityCost(enchantment, (Integer)pair.getRight());
                    capacity.merge((String)slot, cost, Integer::sum);
                });
            }
        });
    }

    @Nullable
    public static Pair<Enchantment, Integer> getEnchantment(CompoundTag nbt) {
        return Registry.f_122825_.m_6612_(new ResourceLocation(nbt.m_128461_("id"))).map(enchantment -> Pair.of((Object)enchantment, (Object)nbt.m_128451_("lvl"))).orElse(null);
    }

    public static int getEnchantmentCapacityCost(Enchantment enchantment, int level) {
        return -(enchantment.m_6175_(level) + enchantment.m_6183_(level)) / 2;
    }

    public static void removeEnchantment(ItemStack itemStack, Enchantment enchantment) {
        Optional.ofNullable(Registry.f_122825_.m_7981_((Object)enchantment)).ifPresent(enchantmentKey -> TetraEnchantmentHelper.removeEnchantment(itemStack, enchantmentKey.toString()));
    }

    public static void removeEnchantment(ItemStack itemStack, String enchantment) {
        Optional.ofNullable(itemStack.m_41737_("EnchantmentMapping")).ifPresent(map -> map.m_128473_(enchantment));
        Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).ifPresent(enchantments -> enchantments.removeIf(nbt -> enchantment.equals(((CompoundTag)nbt).m_128461_("id"))));
    }

    public static void removeEnchantments(ItemStack itemStack, String slot) {
        CompoundTag map = itemStack.m_41737_("EnchantmentMapping");
        ListTag enchantments = Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128437_("Enchantments", 10)).orElse(null);
        if (map != null && enchantments != null) {
            Set<String> matchingEnchantments = map.m_128431_().stream().filter(ench -> slot.equals(map.m_128461_(ench))).collect(Collectors.toSet());
            enchantments.removeIf(nbt -> matchingEnchantments.contains(((CompoundTag)nbt).m_128461_("id")));
            matchingEnchantments.forEach(arg_0 -> ((CompoundTag)map).m_128473_(arg_0));
        }
    }

    public static String getEnchantmentTooltip(Enchantment enchantment, int level, boolean clearFormatting) {
        if (clearFormatting) {
            return ChatFormatting.m_126649_((String)TetraEnchantmentHelper.getEnchantmentName(enchantment, level));
        }
        return TetraEnchantmentHelper.getEnchantmentName(enchantment, level);
    }

    public static String getEnchantmentName(Enchantment enchantment, int level) {
        return enchantment.m_44700_(level).getString();
    }

    public static String getEnchantmentDescription(Enchantment enchantment) {
        return Optional.of(enchantment.m_44704_() + ".desc").filter(I18n::m_118936_).map(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])).orElse(null);
    }

    static {
        aspectMap.put(ItemAspect.armor, new EnchantmentRules(EnchantmentCategory.ARMOR, "additions/armor", "exclusions/armor"));
        aspectMap.put(ItemAspect.armorFeet, new EnchantmentRules(EnchantmentCategory.ARMOR_FEET, "additions/armor_feet", "exclusions/armor_feet"));
        aspectMap.put(ItemAspect.armorLegs, new EnchantmentRules(EnchantmentCategory.ARMOR_LEGS, "additions/armor_legs", "exclusions/armor_legs"));
        aspectMap.put(ItemAspect.armorChest, new EnchantmentRules(EnchantmentCategory.ARMOR_CHEST, "additions/armor_chest", "exclusions/armor_chest"));
        aspectMap.put(ItemAspect.armorHead, new EnchantmentRules(EnchantmentCategory.ARMOR_HEAD, "additions/armor_head", "exclusions/armor_head"));
        aspectMap.put(ItemAspect.edgedWeapon, new EnchantmentRules(EnchantmentCategory.WEAPON, "additions/edged_weapon", "exclusions/edged_weapon"));
        aspectMap.put(ItemAspect.bluntWeapon, new EnchantmentRules(EnchantmentCategory.WEAPON, "additions/blunt_weapon", "exclusions/blunt_weapon"));
        aspectMap.put(ItemAspect.pointyWeapon, new EnchantmentRules(EnchantmentCategory.TRIDENT, "additions/pointy_weapon", "exclusions/pointy_weapon"));
        aspectMap.put(ItemAspect.throwable, new EnchantmentRules(null, "additions/throwable", "exclusions/throwable"));
        aspectMap.put(ItemAspect.blockBreaker, new EnchantmentRules(EnchantmentCategory.DIGGER, "additions/block_breaker", "exclusions/block_breaker"));
        aspectMap.put(ItemAspect.fishingRod, new EnchantmentRules(EnchantmentCategory.FISHING_ROD, "additions/fishing_rod", "exclusions/fishing_rod"));
        aspectMap.put(ItemAspect.breakable, new EnchantmentRules(EnchantmentCategory.BREAKABLE, "additions/breakable", "exclusions/breakable"));
        aspectMap.put(ItemAspect.bow, new EnchantmentRules(EnchantmentCategory.BOW, "additions/bow", "exclusions/bow"));
        aspectMap.put(ItemAspect.wearable, new EnchantmentRules(EnchantmentCategory.WEARABLE, "additions/wearable", "exclusions/wearable"));
        aspectMap.put(ItemAspect.crossbow, new EnchantmentRules(EnchantmentCategory.CROSSBOW, "additions/crossbow", "exclusions/crossbow"));
        aspectMap.put(ItemAspect.vanishable, new EnchantmentRules(EnchantmentCategory.VANISHABLE, "additions/vanishable", "exclusions/vanishable"));
    }

    public static class EnchantmentRules {
        EnchantmentCategory category;
        ResourceLocation exclusions;
        ResourceLocation additions;

        public EnchantmentRules(@Nullable EnchantmentCategory category, String additions, String exclusions) {
            this.category = category;
            this.exclusions = new ResourceLocation("tetra", exclusions);
            this.additions = new ResourceLocation("tetra", additions);
        }

        public boolean isApplicable(Enchantment enchantment) {
            Set tags = enchantment.getTags();
            return (this.category != null && this.category.equals((Object)enchantment.f_44672_) || tags.contains(this.additions)) && !tags.contains(this.exclusions);
        }
    }
}

