/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;

@ParametersAreNonnullByDefault
public class FracturedBedrockTile
extends BlockEntity {
    public static final Set<Material> breakMaterials = Sets.newHashSet((Object[])new Material[]{Material.f_76278_, Material.f_76313_, Material.f_76314_});
    private static final Logger logger = LogManager.getLogger();
    private static final String activityKey = "actv";
    private static final String stepKey = "step";
    private static final String luckKey = "luck";
    private static final ResourceLocation[] lootTables = new ResourceLocation[]{new ResourceLocation("tetra", "extractor/tier1"), new ResourceLocation("tetra", "extractor/tier2"), new ResourceLocation("tetra", "extractor/tier3"), new ResourceLocation("tetra", "extractor/tier4")};
    @ObjectHolder(value="tetra:fractured_bedrock")
    public static BlockEntityType<FracturedBedrockTile> type;
    private final float spawnRatio = 0.5f;
    private final int spawnYLimit = 4;
    private int activity = 0;
    private int step = 0;
    private int luck = 0;
    private MobSpawnSettings spawnInfo;

    public FracturedBedrockTile(BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static boolean breakBlock(Level world, BlockPos pos, BlockState blockState) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (!blockState.m_60795_() && breakMaterials.contains(blockState.m_60767_()) && blockState.m_60800_((BlockGetter)world, pos) > -1.0f) {
                BlockEntity tile = blockState.m_60734_() instanceof EntityBlock ? world.m_7702_(pos) : null;
                LootContext.Builder lootBuilder = new LootContext.Builder(serverLevel).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tile).m_78984_(LootContextParams.f_81455_, null);
                blockState.m_60724_(lootBuilder).forEach(itemStack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)itemStack));
                world.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)world.m_8055_(pos)));
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                return true;
            }
        }
        return false;
    }

    public void updateLuck() {
        boolean spawnBonus;
        if (this.spawnInfo == null) {
            this.spawnInfo = this.f_58857_.m_46857_(this.f_58858_).m_47518_();
        }
        if (spawnBonus = this.spawnInfo.m_151798_(MobCategory.MONSTER).m_146338_().stream().map(spawner -> spawner.f_48404_).anyMatch(type -> EntityType.f_20458_.equals(type) || EntityType.f_20481_.equals(type) || EntityType.f_20495_.equals(type))) {
            ++this.luck;
        }
    }

    public void activate(int amount) {
        if (!this.f_58857_.f_46443_ && this.activity <= 0) {
            this.playSound();
        }
        int preTier = this.getProjectedTier();
        this.activity += amount;
        this.m_6596_();
        if (!this.f_58857_.f_46443_ && this.getProjectedTier() != preTier) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private int getRate() {
        return 20 - Mth.m_14045_((int)(this.activity / 64 * 5), (int)0, (int)15);
    }

    private int getIntensity() {
        return Math.min(1 + this.activity / 16, 4);
    }

    public int getProjectedTier() {
        return this.getTier(this.step + this.activity);
    }

    private int getTier() {
        return this.getTier(this.step);
    }

    private int getTier(int ref) {
        if (ref > 10240) {
            return 3;
        }
        if (ref > 4096) {
            return 2;
        }
        if (ref > 1024) {
            return 1;
        }
        return 0;
    }

    private int getMaxDistance() {
        switch (this.getTier()) {
            case 0: {
                return 12;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 25;
            }
        }
        return 25;
    }

    private boolean shouldDeplete() {
        return this.step >= 12288;
    }

    private Vec3 getTarget(int i) {
        int maxDistance = this.getMaxDistance();
        int steps = 32;
        double directionRotation = 90.0 * (double)(i % 4);
        double offsetRotation = 360.0 / (double)steps * (double)(i / 4) + (double)((float)i / 8.0f);
        float pitch = (float)(-(i % (steps * 16)) / steps) * 5.0f;
        return Vec3.m_82498_((float)pitch, (float)((float)(directionRotation + offsetRotation))).m_82542_((double)maxDistance, (double)(4.0f + (float)maxDistance / 2.0f), (double)maxDistance);
    }

    private boolean isBedrock(Block block) {
        return Blocks.f_50752_.equals(block) || FracturedBedrockBlock.instance.equals(block) || SeepingBedrockBlock.instance.equals(block) || ChthonicExtractorBlock.instance.equals(block);
    }

    private boolean canReplace(BlockState blockState) {
        return blockState.m_60767_().m_76336_();
    }

    private BlockHitResult raytrace(Level level, Vec3 origin, Vec3 target) {
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)origin, (Vec3)target, (Object)new ClipContext(origin, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), (ctx, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            if (this.isBedrock(block) || this.canReplace(blockState)) {
                return null;
            }
            VoxelShape voxelshape = ctx.m_45694_(blockState, (BlockGetter)level, blockPos);
            return level.m_45558_(origin, target, blockPos, voxelshape, blockState);
        }, ctx -> {
            Vec3 vec3 = ctx.m_45702_().m_82546_(ctx.m_45693_());
            return BlockHitResult.m_82426_((Vec3)ctx.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)new BlockPos(ctx.m_45693_()));
        });
    }

    private BlockPos traceDown(BlockPos blockPos, int minY, Level level) {
        BlockPos.MutableBlockPos movePos = blockPos.m_122032_();
        while (movePos.m_123342_() > minY) {
            movePos.m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)movePos);
            if (this.isBedrock(blockState.m_60734_())) {
                return movePos.m_122173_(Direction.UP).m_7949_();
            }
            if (blockState.m_60795_()) continue;
            return movePos.m_7949_();
        }
        return movePos.m_7949_();
    }

    private void spawnOre(BlockPos pos) {
        ServerLevel serverWorld = (ServerLevel)this.f_58857_;
        LootTable table = serverWorld.m_142572_().m_129898_().m_79217_(lootTables[this.getTier()]);
        LootContext context = new LootContext.Builder(serverWorld).m_78963_((float)this.luck).m_78975_(LootContextParamSets.f_81410_);
        table.m_79129_(context).stream().filter(itemStack -> !itemStack.m_41619_()).findAny().ifPresent(itemStack -> {
            Item patt9652$temp = itemStack.m_41720_();
            if (patt9652$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt9652$temp;
                BlockState newState = blockItem.m_40614_().m_49966_();
                this.f_58857_.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)newState));
                this.f_58857_.m_7731_(pos, newState, 2);
            } else {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)pos, (ItemStack)itemStack);
            }
        });
    }

    private void spawnMob(BlockPos pos) {
        if (this.spawnInfo == null) {
            this.spawnInfo = this.f_58857_.m_46857_(pos).m_47518_();
        }
        if (this.m_58899_().m_123331_((Vec3i)pos) < 42.0 || this.f_58857_.m_5822_().nextFloat() >= this.spawnInfo.m_48344_() / 4.0f) {
            return;
        }
        WeightedRandomList spawners = this.spawnInfo.m_151798_(MobCategory.MONSTER);
        Optional optionalSpawnerData = spawners.m_146335_(this.f_58857_.m_5822_());
        if (!optionalSpawnerData.isPresent()) {
            return;
        }
        MobSpawnSettings.SpawnerData mob = (MobSpawnSettings.SpawnerData)optionalSpawnerData.get();
        Vec3 spawnPos = Vec3.m_82539_((Vec3i)pos);
        ServerLevel serverWorld = (ServerLevel)this.f_58857_;
        if (mob.f_48404_.m_20654_() && serverWorld.m_45772_(mob.f_48404_.m_20585_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_)) && SpawnPlacements.m_21759_((EntityType)mob.f_48404_, (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)pos, (Random)serverWorld.m_5822_())) {
            Entity entity;
            try {
                entity = mob.f_48404_.m_20615_((Level)serverWorld.m_6018_());
            }
            catch (Exception exception) {
                logger.warn("Failed to create mob", (Throwable)exception);
                return;
            }
            entity.m_20219_(spawnPos);
            CastOptional.cast((Object)entity, Mob.class).filter(e -> ForgeHooks.canEntitySpawn((Mob)e, (LevelAccessor)serverWorld, (double)spawnPos.f_82479_, (double)spawnPos.f_82480_, (double)spawnPos.f_82481_, null, (MobSpawnType)MobSpawnType.SPAWNER) != -1).filter(e -> e.m_5545_((LevelAccessor)serverWorld, MobSpawnType.SPAWNER)).filter(e -> e.m_6914_((LevelReader)serverWorld)).ifPresent(e -> {
                e.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(e.m_142538_()), MobSpawnType.SPAWNER, null, null);
                serverWorld.m_47205_((Entity)e);
                serverWorld.m_45976_(Player.class, new AABB(this.m_58899_()).m_82377_(24.0, 8.0, 24.0)).stream().findAny().ifPresent(arg_0 -> ((Mob)e).m_21335_(arg_0));
            });
        }
    }

    private void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_.m_6625_(this.f_58858_.m_123342_()), SoundEvents.f_11737_, SoundSource.BLOCKS, 3.0f, 0.5f);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_(activityKey)) {
            this.activity = compound.m_128451_(activityKey);
        }
        if (compound.m_128441_(stepKey)) {
            this.step = compound.m_128451_(stepKey);
        }
        if (compound.m_128441_(luckKey)) {
            this.luck = compound.m_128451_(luckKey);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(activityKey, this.activity);
        compound.m_128405_(stepKey, this.step);
        compound.m_128405_(luckKey, this.luck);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_ && this.activity > 0 && level.m_46467_() % (long)this.getRate() == 0L) {
            int intensity = this.getIntensity();
            Vec3 origin = Vec3.m_82512_((Vec3i)pos);
            for (int i = 0; i < intensity; ++i) {
                Vec3 target = this.getTarget(this.step + i);
                BlockHitResult result = this.raytrace(level, origin, origin.m_82549_(target));
                if (result.m_6662_() == HitResult.Type.MISS) continue;
                BlockPos hitPos = result.m_82425_();
                BlockState hitState = level.m_8055_(hitPos);
                FracturedBedrockTile.breakBlock(level, hitPos, hitState);
                int minY = level.m_141937_();
                BlockPos spawnPos = this.traceDown(hitPos, minY, level);
                BlockState spawnState = level.m_8055_(spawnPos);
                if (this.canReplace(spawnState)) {
                    if (level.m_5822_().nextFloat() < 0.5f) {
                        if (spawnPos.m_123342_() >= minY + 4) continue;
                        this.spawnOre(spawnPos);
                        continue;
                    }
                    this.spawnMob(spawnPos);
                    continue;
                }
                FracturedBedrockTile.breakBlock(level, spawnPos, spawnState);
            }
            ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, FracturedBedrockBlock.instance.m_49966_()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.1, (double)this.f_58858_.m_123343_() + 0.5, 8, 0.0, level.f_46441_.nextGaussian() * 0.1, 0.0, 0.1);
            this.step += intensity;
            this.activity -= intensity;
            if (this.shouldDeplete()) {
                level.m_7731_(this.m_58899_(), DepletedBedrockBlock.instance.m_49966_(), 2);
            }
        }
        if (!level.f_46443_ && this.activity > 0 && this.f_58857_.m_46467_() % 80L == 0L) {
            this.playSound();
        }
    }
}

