/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.gui.ToggleableSlot;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;

@ParametersAreNonnullByDefault
public class ForgedContainerContainer
extends AbstractContainerMenu {
    @ObjectHolder(value="tetra:forged_container")
    public static MenuType<ForgedContainerContainer> type;
    private final ForgedContainerTile tile;
    private ToggleableSlot[][] compartmentSlots;
    private int currentCompartment = 0;

    public ForgedContainerContainer(int windowId, ForgedContainerTile tile, Container playerInventory, Player player) {
        super(type, windowId);
        int i;
        this.tile = tile;
        tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.compartmentSlots = new ToggleableSlot[ForgedContainerTile.compartmentCount][];
            for (int i = 0; i < this.compartmentSlots.length; ++i) {
                this.compartmentSlots[i] = new ToggleableSlot[ForgedContainerTile.compartmentSize];
                int offset = i * ForgedContainerTile.compartmentSize;
                for (int j = 0; j < 6; ++j) {
                    for (int k = 0; k < 9; ++k) {
                        int index = j * 9 + k;
                        this.compartmentSlots[i][index] = new ToggleableSlot(handler, index + offset, k * 17 + 12, j * 17);
                        this.compartmentSlots[i][index].toggle(i == 0);
                        this.m_38897_((Slot)this.compartmentSlots[i][index]);
                    }
                }
            }
        });
        InvWrapper playerInventoryHandler = new InvWrapper(playerInventory);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, i * 9 + j + 9, j * 17 + 12, i * 17 + 116));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, i, i * 17 + 12, 171));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ForgedContainerContainer create(int windowId, BlockPos pos, Inventory inv) {
        ForgedContainerTile te = (ForgedContainerTile)Minecraft.m_91087_().f_91073_.m_7702_(pos);
        return new ForgedContainerContainer(windowId, te, (Container)inv, (Player)Minecraft.m_91087_().f_91074_);
    }

    public void changeCompartment(int compartmentIndex) {
        this.currentCompartment = compartmentIndex;
        for (int i = 0; i < this.compartmentSlots.length; ++i) {
            boolean enabled = i == compartmentIndex;
            Arrays.stream(this.compartmentSlots[i]).forEach(slot -> slot.toggle(enabled));
        }
        if (this.tile.m_58904_().f_46443_) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new ChangeCompartmentPacket(compartmentIndex));
        }
    }

    private int getSlots() {
        return this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse(0);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack resultStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            resultStack = slotStack.m_41777_();
            if (index < this.getSlots() ? !this.m_38903_(slotStack, this.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, this.currentCompartment * ForgedContainerTile.compartmentSize, (this.currentCompartment + 1) * ForgedContainerTile.compartmentSize, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return resultStack;
    }

    public boolean m_6875_(Player playerIn) {
        return ForgedContainerContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_()), (Player)playerIn, (Block)ForgedContainerBlock.instance);
    }

    public ForgedContainerTile getTile() {
        return this.tile;
    }
}

