/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ForgedContainerRenderer
implements BlockEntityRenderer<ForgedContainerTile> {
    public static final Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("tetra", "blocks/forged_container/forged_container"));
    private static final float openDuration = 300.0f;
    public static ModelLayerLocation layer = new ModelLayerLocation(new ResourceLocation("tetra", "forged_container"), "main");
    public ModelPart lid;
    public ModelPart base;
    public ModelPart[] locks;

    public ForgedContainerRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(layer);
        this.lid = modelpart.m_171324_("lid");
        this.locks = new ModelPart[4];
        for (int i = 0; i < 4; ++i) {
            this.locks[i] = modelpart.m_171324_("locks" + i);
        }
        this.base = modelpart.m_171324_("base");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        parts.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -3.0f, -14.0f, 30.0f, 3.0f, 14.0f), PartPose.f_171404_);
        for (int i = 0; i < 4; ++i) {
            parts.m_171599_("locks" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_((float)(-2 + i * 6), -1.0f, -14.03f, 2.0f, 3.0f, 1.0f), PartPose.f_171404_);
        }
        parts.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(0.0f, 1.0f, 0.0f, 30.0f, 9.0f, 14.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void render(ForgedContainerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile.isFlipped()) {
            return;
        }
        if (tile.m_58898_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(tile.getFacing().m_122435_()));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            VertexConsumer vertexBuilder = material.m_119194_(renderTypeBuffer, RenderType::m_110446_);
            this.renderLid(tile, partialTicks, matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.renderLocks(tile, partialTicks, matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.base.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            matrixStack.m_85849_();
        }
    }

    private void renderLid(ForgedContainerTile tile, float partialTicks, PoseStack matrixStack, VertexConsumer vertexBuilder, int combinedLight, int combinedOverlay) {
        if (tile.isOpen()) {
            float progress = Math.min(1.0f, (float)(System.currentTimeMillis() - tile.openTime) / 300.0f);
            this.lid.f_104204_ = progress * 0.1f * 1.5707964f;
            matrixStack.m_85837_(0.0, 0.0, (double)(0.3f * progress));
            this.lid.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            matrixStack.m_85837_(0.0, 0.0, (double)(-0.3f * progress));
        } else {
            this.lid.f_104204_ = 0.0f;
            this.lid.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        }
    }

    private void renderLocks(ForgedContainerTile tile, float partialTicks, PoseStack matrixStack, VertexConsumer vertexBuilder, int combinedLight, int combinedOverlay) {
        Boolean[] locked = tile.isLocked();
        for (int i = 0; i < this.locks.length; ++i) {
            if (!locked[i].booleanValue()) continue;
            this.locks[i].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        }
    }
}

