/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlock;

@ParametersAreNonnullByDefault
public class CoreExtractorBaseBlock
extends TetraWaterloggedBlock
implements EntityBlock {
    public static final DirectionProperty facingProp = HorizontalDirectionalBlock.f_54117_;
    public static final String unlocalizedName = "core_extractor";
    private static final VoxelShape capShape = CoreExtractorBaseBlock.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape shaftShape = CoreExtractorBaseBlock.m_49796_((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private static final VoxelShape smallCoverShapeZ = CoreExtractorBaseBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0);
    private static final VoxelShape largeCoverShapeZ = CoreExtractorBaseBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)13.0, (double)15.0);
    private static final VoxelShape smallCoverShapeX = CoreExtractorBaseBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)15.0);
    private static final VoxelShape largeCoverShapeX = CoreExtractorBaseBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0);
    private static final VoxelShape combinedShapeZ = Shapes.m_83124_((VoxelShape)Shapes.m_83148_((VoxelShape)smallCoverShapeZ, (VoxelShape)largeCoverShapeZ, (BooleanOp)BooleanOp.f_82695_), (VoxelShape[])new VoxelShape[]{capShape, shaftShape});
    private static final VoxelShape combinedShapeX = Shapes.m_83124_((VoxelShape)Shapes.m_83148_((VoxelShape)smallCoverShapeX, (VoxelShape)largeCoverShapeX, (BooleanOp)BooleanOp.f_82695_), (VoxelShape[])new VoxelShape[]{capShape, shaftShape});
    @ObjectHolder(value="tetra:core_extractor")
    public static CoreExtractorBaseBlock instance;

    public CoreExtractorBaseBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (Direction.Axis.X.equals((Object)((Direction)state.m_61143_((Property)facingProp)).m_122434_())) {
            return combinedShapeX;
        }
        return combinedShapeZ;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
        tooltip.add((Component)new TextComponent(" "));
        tooltip.add((Component)new TranslatableComponent("block.multiblock_hint.1x2x1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        if (!pos.m_142300_((Direction)world.m_8055_(pos).m_61143_((Property)facingProp)).equals((Object)fromPos)) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, CoreExtractorBaseTile.class).ifPresent(CoreExtractorBaseTile::updateTransferState);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{facingProp});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.UP.equals((Object)facing) && !CoreExtractorPistonBlock.instance.equals(facingState.m_60734_())) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState pistonState = (BlockState)CoreExtractorPistonBlock.instance.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_));
        world.m_7731_(pos.m_7494_(), pistonState, 3);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)facingProp)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CoreExtractorBaseTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return CoreExtractorBaseBlock.getTicker(entityType, CoreExtractorBaseTile.type, (lvl, pos, blockState, tile) -> tile.tick(lvl, pos, blockState));
    }
}

