/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferConfig;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferEffect;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferState;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;

@ParametersAreNonnullByDefault
public class TransferUnitBlock
extends TetraWaterloggedBlock
implements IInteractiveBlock,
EntityBlock {
    public static final DirectionProperty facingProp = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty plateProp = BooleanProperty.m_61465_((String)"plate");
    public static final IntegerProperty cellProp = IntegerProperty.m_61631_((String)"cell", (int)0, (int)2);
    public static final EnumProperty<EnumTransferConfig> configProp = EnumProperty.m_61587_((String)"config", EnumTransferConfig.class);
    public static final EnumProperty<EnumTransferState> transferProp = EnumProperty.m_61587_((String)"transfer", EnumTransferState.class);
    public static final String unlocalizedName = "transfer_unit";
    private static final ResourceLocation plateLootTable = new ResourceLocation("tetra", "forged/plate_break");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(TetraToolActions.pry, 1, Direction.SOUTH, 3.0f, 11.0f, 4.0f, 6.0f, new PropertyMatcher().where(plateProp, Predicates.equalTo((Object)true)), TransferUnitBlock::removePlate), new BlockInteraction(TetraToolActions.hammer, 1, Direction.SOUTH, 4.0f, 10.0f, 5.0f, 9.0f, new PropertyMatcher().where(plateProp, Predicates.equalTo((Object)false)), TransferUnitBlock::reconfigure)};
    private static final VoxelShape eastShape = TransferUnitBlock.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)15.0);
    private static final VoxelShape northShape = TransferUnitBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)12.0, (double)13.0);
    private static final VoxelShape westShape = TransferUnitBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)12.0, (double)15.0);
    private static final VoxelShape southShape = TransferUnitBlock.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)12.0, (double)16.0);
    @ObjectHolder(value="tetra:transfer_unit")
    public static TransferUnitBlock instance;

    public TransferUnitBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)plateProp, (Comparable)Boolean.valueOf(false))).m_61124_((Property)cellProp, (Comparable)Integer.valueOf(0))).m_61124_(configProp, (Comparable)((Object)EnumTransferConfig.a))).m_61124_(transferProp, (Comparable)((Object)EnumTransferState.none)));
    }

    public static boolean removePlate(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction hitFace) {
        if (!world.f_46443_) {
            if (player != null) {
                BlockInteraction.dropLoot(plateLootTable, player, hand, (ServerLevel)world, blockState);
            } else {
                BlockInteraction.dropLoot(plateLootTable, (ServerLevel)world, pos, blockState);
            }
        }
        world.m_5594_(player, pos, SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.5f);
        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)plateProp, (Comparable)Boolean.valueOf(false)), 3);
        return true;
    }

    public static boolean attachPlate(Level world, BlockPos pos, BlockState blockState, Player player) {
        world.m_5594_(player, pos, SoundEvents.f_12065_, SoundSource.PLAYERS, 0.5f, 1.0f);
        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)plateProp, (Comparable)Boolean.valueOf(true)), 3);
        return true;
    }

    public static boolean reconfigure(Level world, BlockPos pos, BlockState blockState, @Nullable Player player, @Nullable InteractionHand hand, Direction hitFace) {
        EnumTransferConfig config = EnumTransferConfig.getNextConfiguration((EnumTransferConfig)((Object)blockState.m_61143_(configProp)));
        world.m_5594_(player, pos, SoundEvents.f_11667_, SoundSource.PLAYERS, 1.0f, 1.0f);
        world.m_7731_(pos, (BlockState)blockState.m_61124_(configProp, (Comparable)((Object)config)), 3);
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, TransferUnitTile.class).ifPresent(TransferUnitTile::updateTransferState);
        return true;
    }

    public static EnumTransferEffect getEffectPowered(Level world, BlockPos pos, BlockState blockState) {
        EnumTransferEffect effect = EnumTransferEffect.fromConfig((EnumTransferConfig)((Object)blockState.m_61143_(configProp)), 0L);
        if (effect.equals((Object)EnumTransferEffect.redstone)) {
            Direction facing = (Direction)blockState.m_61143_((Property)facingProp);
            if (world.m_46616_(pos.m_142300_(facing.m_122427_()), facing.m_122427_())) {
                return EnumTransferEffect.send;
            }
            if (world.m_46616_(pos.m_142300_(facing.m_122428_()), facing.m_122428_())) {
                return EnumTransferEffect.receive;
            }
        }
        return effect;
    }

    public static void setReceiving(Level world, BlockPos pos, BlockState blockState, boolean receiving) {
        EnumTransferState newState = receiving ? EnumTransferState.receiving : EnumTransferState.none;
    }

    public static boolean isReceiving(BlockState blockState) {
        return EnumTransferState.receiving.equals(blockState.m_61143_(transferProp));
    }

    public static void setSending(Level world, BlockPos pos, BlockState blockState, boolean sending) {
        EnumTransferState newState = sending ? EnumTransferState.sending : EnumTransferState.none;
    }

    public static boolean isSending(BlockState blockState) {
        return EnumTransferState.sending.equals(blockState.m_61143_(transferProp));
    }

    public static boolean hasPlate(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)plateProp);
    }

    public static void updateCellProp(Level world, BlockPos pos, boolean hasCell, int cellCharge) {
        BlockState blockState = world.m_8055_(pos);
        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)cellProp, (Comparable)Integer.valueOf(hasCell ? (cellCharge > 0 ? 2 : 1) : 0)), 3);
    }

    public static Direction getFacing(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)facingProp);
    }

    @Override
    public void clientInit() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_());
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolAction> tools) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(world, pos, blockState, (Direction)blockState.m_61143_((Property)facingProp), face, tools)).toArray(BlockInteraction[]::new);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction blockFacing = (Direction)state.m_61143_((Property)facingProp);
        TransferUnitTile tile = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, TransferUnitTile.class).orElse(null);
        ItemStack heldStack = player.m_21120_(hand);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        if (hit.m_82434_().equals((Object)Direction.UP)) {
            if (tile.hasCell()) {
                ItemStack cell = tile.removeCell();
                if (player.m_150109_().m_36054_(cell)) {
                    player.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                } else {
                    TransferUnitBlock.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)cell);
                }
                world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.6f);
                world.m_7260_(pos, state, state, 3);
                if (!player.f_19853_.f_46443_) {
                    BlockUseCriterion.trigger((ServerPlayer)player, state, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41720_() instanceof ItemCellMagmatic) {
                tile.putCell(heldStack);
                player.m_21008_(hand, ItemStack.f_41583_);
                world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.5f);
                world.m_7260_(pos, state, state, 3);
                if (!player.f_19853_.f_46443_) {
                    BlockUseCriterion.trigger((ServerPlayer)player, state, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (blockFacing.equals((Object)hit.m_82434_().m_122424_()) && heldStack.m_41720_() instanceof InsulatedPlateItem && !((Boolean)state.m_61143_((Property)plateProp)).booleanValue()) {
            TransferUnitBlock.attachPlate(world, pos, state, player);
            heldStack.m_41774_(1);
            if (!player.f_19853_.f_46443_) {
                BlockUseCriterion.trigger((ServerPlayer)player, state, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        }
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.m_60734_())) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, TransferUnitTile.class).ifPresent(tile -> {
                if (tile.hasCell()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tile.getCell().m_41777_());
                }
            });
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, TransferUnitTile.class).ifPresent(BlockEntity::m_7651_);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        if (!pos.m_142300_((Direction)world.m_8055_(pos).m_61143_((Property)facingProp)).equals((Object)fromPos)) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, TransferUnitTile.class).ifPresent(TransferUnitTile::updateTransferState);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)facingProp);
        switch (facing) {
            case NORTH: {
                return northShape;
            }
            case EAST: {
                return eastShape;
            }
            case SOUTH: {
                return southShape;
            }
            case WEST: {
                return westShape;
            }
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{facingProp, configProp, plateProp, cellProp, transferProp});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_8125_());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)facingProp)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransferUnitTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return TransferUnitBlock.getTicker(entityType, TransferUnitTile.type, (lvl, pos, blockState, tile) -> tile.tick(lvl, pos, blockState));
    }
}

