/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.IHeatTransfer;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferEffect;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;

@ParametersAreNonnullByDefault
public class TransferUnitTile
extends BlockEntity
implements IHeatTransfer {
    private static final int baseAmount = 8;
    @ObjectHolder(value="tetra:transfer_unit")
    public static BlockEntityType<TransferUnitTile> type;
    private ItemStack cell = ItemStack.f_41583_;
    private float efficiency = 1.0f;

    public TransferUnitTile(BlockPos p_155268_, BlockState p_155269_) {
        super(type, p_155268_, p_155269_);
    }

    public static void writeCell(CompoundTag compound, ItemStack cell) {
        if (!cell.m_41619_()) {
            CompoundTag cellNBT = new CompoundTag();
            cell.m_41739_(cellNBT);
            compound.m_128365_("cell", (Tag)cellNBT);
        }
    }

    @Override
    public boolean canRecieve() {
        return TransferUnitBlock.getEffectPowered(this.f_58857_, this.f_58858_, this.m_58900_()).equals((Object)EnumTransferEffect.receive) && this.hasCell() && this.getCharge() < 128;
    }

    @Override
    public boolean canSend() {
        return TransferUnitBlock.getEffectPowered(this.f_58857_, this.f_58858_, this.m_58900_()).equals((Object)EnumTransferEffect.send) && this.hasCell() && this.getCharge() > 0;
    }

    @Override
    public boolean isReceiving() {
        return TransferUnitBlock.isReceiving(this.m_58900_());
    }

    @Override
    public void setReceiving(boolean receiving) {
        TransferUnitBlock.setReceiving(this.f_58857_, this.f_58858_, this.m_58900_(), receiving);
    }

    @Override
    public boolean isSending() {
        return TransferUnitBlock.isSending(this.m_58900_());
    }

    @Override
    public void setSending(boolean sending) {
        TransferUnitBlock.setSending(this.f_58857_, this.f_58858_, this.m_58900_(), sending);
    }

    public boolean hasCell() {
        return !this.cell.m_41619_();
    }

    public ItemStack removeCell() {
        ItemStack removedCell = this.cell;
        this.cell = ItemStack.f_41583_;
        TransferUnitBlock.updateCellProp(this.f_58857_, this.f_58858_, this.hasCell(), this.getCharge());
        this.updateTransferState();
        return removedCell;
    }

    public ItemStack getCell() {
        return this.cell;
    }

    public boolean putCell(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ItemCellMagmatic) {
            this.cell = itemStack;
            TransferUnitBlock.updateCellProp(this.f_58857_, this.f_58858_, this.hasCell(), this.getCharge());
            this.updateTransferState();
            return true;
        }
        return false;
    }

    private Optional<IHeatTransfer> getConnectedUnit() {
        return TileEntityOptional.from((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_.m_142300_(TransferUnitBlock.getFacing(this.m_58900_())), IHeatTransfer.class);
    }

    @Override
    public int getCharge() {
        return CastOptional.cast((Object)this.cell.m_41720_(), ItemCellMagmatic.class).map(item -> item.getCharge(this.cell)).orElse(0);
    }

    @Override
    public float getEfficiency() {
        return TransferUnitBlock.hasPlate(this.m_58900_()) ? 1.0f : 0.9f;
    }

    @Override
    public int getReceiveLimit() {
        return 8;
    }

    @Override
    public int getSendLimit() {
        return 8;
    }

    @Override
    public int drain(int amount) {
        return CastOptional.cast((Object)this.cell.m_41720_(), ItemCellMagmatic.class).map(item -> {
            int drained = item.drainCharge(this.cell, amount);
            if (item.getCharge(this.cell) == 0) {
                TransferUnitBlock.updateCellProp(this.f_58857_, this.f_58858_, this.hasCell(), 0);
                this.runDrainedEffects();
            }
            return drained;
        }).orElse(0);
    }

    @Override
    public int fill(int amount) {
        return CastOptional.cast((Object)this.cell.m_41720_(), ItemCellMagmatic.class).map(item -> {
            int initialCharge = item.getCharge(this.cell);
            int overfill = item.recharge(this.cell, amount);
            if (item.getCharge(this.cell) == 128) {
                this.runFilledEffects();
            }
            if (initialCharge == 0) {
                TransferUnitBlock.updateCellProp(this.f_58857_, this.f_58858_, this.hasCell(), this.getCharge());
            }
            this.m_6596_();
            return overfill;
        }).orElse(0);
    }

    public void tick(Level level, BlockPos pos, BlockState blockState) {
        if (!level.f_46443_ && level.m_46467_() % 5L == 0L && TransferUnitBlock.isSending(blockState)) {
            this.transfer();
        }
    }

    public void transfer() {
        if (this.canSend()) {
            this.getConnectedUnit().ifPresent(connected -> {
                if (connected.canRecieve()) {
                    int amount = this.drain(8);
                    int overfill = connected.fill((int)((float)amount * this.efficiency));
                    if (overfill > 0) {
                        this.fill(overfill);
                    }
                    this.m_6596_();
                } else {
                    this.setSending(false);
                    connected.setReceiving(false);
                }
            });
        } else {
            this.getConnectedUnit().ifPresent(connected -> connected.setReceiving(false));
            this.setSending(false);
        }
    }

    private void runDrainedEffects() {
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, (double)0.02f);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    private void runFilledEffects() {
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public void updateTransferState() {
        switch (TransferUnitBlock.getEffectPowered(this.f_58857_, this.f_58858_, this.m_58900_())) {
            case send: {
                this.getConnectedUnit().ifPresent(connected -> {
                    boolean canTransfer = this.canSend() && connected.canRecieve();
                    this.setReceiving(false);
                    this.setSending(canTransfer);
                    connected.setReceiving(canTransfer);
                    this.efficiency = this.getEfficiency() * connected.getEfficiency();
                });
                break;
            }
            case receive: {
                this.getConnectedUnit().ifPresent(connected -> {
                    if (this.isSending()) {
                        this.setSending(false);
                    }
                    if (connected.canSend()) {
                        connected.updateTransferState();
                    }
                });
                break;
            }
            case redstone: {
                this.getConnectedUnit().ifPresent(connected -> {
                    connected.setSending(false);
                    connected.setReceiving(false);
                    this.setSending(false);
                    this.setReceiving(false);
                });
            }
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cell = compound.m_128441_("cell") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("cell")) : ItemStack.f_41583_;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        TransferUnitTile.writeCell(compound, this.cell);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }
}

