/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.rack;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;

@ParametersAreNonnullByDefault
public class RackTile
extends BlockEntity {
    public static final String unlocalizedName = "rack";
    public static final int inventorySize = 2;
    private static final String inventoryKey = "inv";
    @ObjectHolder(value="tetra:rack")
    public static BlockEntityType<RackTile> type;
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            RackTile.this.m_6596_();
            RackTile.this.f_58857_.m_7260_(RackTile.this.f_58858_, RackTile.this.m_58900_(), RackTile.this.m_58900_(), 3);
        }
    });

    public RackTile(BlockPos p_155268_, BlockState p_155269_) {
        super(type, p_155268_, p_155269_);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void slotInteract(int slot, Player playerEntity, InteractionHand hand) {
        this.handler.ifPresent(handler -> {
            ItemStack slotStack = handler.getStackInSlot(slot);
            ItemStack heldStack = playerEntity.m_21120_(hand);
            if (slotStack.m_41619_()) {
                ItemStack remainder = handler.insertItem(slot, heldStack.m_41777_(), false);
                playerEntity.m_21008_(hand, remainder);
                playerEntity.m_5496_(SoundEvents.f_12635_, 0.5f, 0.7f);
            } else {
                ItemStack extractedStack = handler.extractItem(slot, handler.getSlotLimit(slot), false);
                if (playerEntity.m_150109_().m_36054_(extractedStack)) {
                    playerEntity.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
                } else {
                    playerEntity.m_36176_(extractedStack, false);
                }
            }
        });
    }

    public AABB getRenderBoundingBox() {
        return Shapes.m_83144_().m_83215_().m_82338_(this.f_58858_);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_(inventoryKey)));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.handler.ifPresent(handler -> compound.m_128365_(inventoryKey, (Tag)handler.serializeNBT()));
    }
}

