/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class BlockInteraction {
    public ToolAction requiredTool;
    public int requiredLevel;
    public boolean alwaysReveal = true;
    public Direction face;
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;
    public Predicate<BlockState> predicate;
    public InteractionOutcome outcome;
    protected boolean applyUsageEffects = true;

    public <V extends Comparable<V>> BlockInteraction(ToolAction requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, InteractionOutcome outcome) {
        this.requiredTool = requiredTool;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.outcome = outcome;
    }

    public BlockInteraction(ToolAction requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Predicate<BlockState> predicate, InteractionOutcome outcome) {
        this(requiredTool, requiredLevel, face, minX, maxX, minY, maxY, outcome);
        this.predicate = predicate;
    }

    public <V extends Comparable<V>> BlockInteraction(ToolAction requiredTool, int requiredLevel, Direction face, float minX, float maxX, float minY, float maxY, Property<V> property, V propertyValue, InteractionOutcome outcome) {
        this(requiredTool, requiredLevel, face, minX, maxX, minY, maxY, new PropertyMatcher().where(property, Predicates.equalTo(propertyValue)), outcome);
    }

    public static InteractionResult attemptInteraction(Level world, BlockState blockState, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        ItemStack heldStack = player.m_21120_(hand);
        Set<ToolAction> availableTools = PropertyHelper.getItemTools(heldStack);
        AABB boundingBox = blockState.m_60651_((BlockGetter)world, pos, CollisionContext.m_82750_((Entity)player)).m_83215_();
        double hitU = 16.0 * BlockInteraction.getHitU(rayTrace.m_82434_(), boundingBox, rayTrace.m_82450_().f_82479_ - (double)pos.m_123341_(), rayTrace.m_82450_().f_82480_ - (double)pos.m_123342_(), rayTrace.m_82450_().f_82481_ - (double)pos.m_123343_());
        double hitV = 16.0 * BlockInteraction.getHitV(rayTrace.m_82434_(), boundingBox, rayTrace.m_82450_().f_82479_ - (double)pos.m_123341_(), rayTrace.m_82450_().f_82480_ - (double)pos.m_123342_(), rayTrace.m_82450_().f_82481_ - (double)pos.m_123343_());
        BlockInteraction possibleInteraction = CastOptional.cast((Object)blockState.m_60734_(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(world, pos, blockState, rayTrace.m_82434_(), availableTools)).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU, hitV)).filter(interaction -> PropertyHelper.getItemToolLevel(heldStack, interaction.requiredTool) >= interaction.requiredLevel).findFirst().orElse(null);
        if (possibleInteraction != null) {
            if (InteractionHand.MAIN_HAND == hand) {
                if ((double)player.m_36403_(0.0f) < 0.8) {
                    if (player.m_21206_().m_41619_()) {
                        player.m_36334_();
                        return InteractionResult.FAIL;
                    }
                    return InteractionResult.PASS;
                }
            } else if (player.m_36335_().m_41519_(heldStack.m_41720_())) {
                return InteractionResult.FAIL;
            }
            possibleInteraction.applyOutcome(world, pos, blockState, player, hand, rayTrace.m_82434_());
            if (availableTools.contains(possibleInteraction.requiredTool) && heldStack.m_41763_()) {
                if (heldStack.m_41720_() instanceof IModularItem) {
                    IModularItem item2 = (IModularItem)heldStack.m_41720_();
                    item2.applyDamage(2, heldStack, (LivingEntity)player);
                    if (possibleInteraction.applyUsageEffects) {
                        item2.applyUsageEffects((LivingEntity)player, heldStack, possibleInteraction.requiredLevel * 2);
                    }
                } else {
                    heldStack.m_41622_(2, (LivingEntity)player, breaker -> breaker.m_21190_(breaker.m_7655_()));
                }
            }
            if (player instanceof ServerPlayer) {
                BlockState newState = world.m_8055_(pos);
                BlockInteractionCriterion.trigger((ServerPlayer)player, newState, possibleInteraction.requiredTool, possibleInteraction.requiredLevel);
            }
            if (InteractionHand.MAIN_HAND == hand) {
                player.m_36334_();
            } else {
                int cooldown = CastOptional.cast((Object)heldStack.m_41720_(), ItemModularHandheld.class).map(item -> (int)(20.0 * item.getCooldownBase(heldStack))).orElse(10);
                player.m_36335_().m_41524_(heldStack.m_41720_(), cooldown);
            }
            if (player.f_19853_.f_46443_) {
                InteractiveBlockOverlay.markDirty();
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static BlockInteraction getInteractionAtPoint(Player player, BlockState blockState, BlockPos pos, Direction hitFace, double hitX, double hitY, double hitZ) {
        AABB boundingBox = blockState.m_60808_((BlockGetter)player.f_19853_, pos).m_83215_();
        double hitU = BlockInteraction.getHitU(hitFace, boundingBox, hitX, hitY, hitZ);
        double hitV = BlockInteraction.getHitV(hitFace, boundingBox, hitX, hitY, hitZ);
        return CastOptional.cast((Object)blockState.m_60734_(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(player.f_19853_, pos, blockState, hitFace, PropertyHelper.getPlayerTools(player))).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU * 16.0, hitV * 16.0)).findFirst().orElse(null);
    }

    private static double getHitU(Direction facing, AABB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.f_82291_ - hitX;
            }
            case UP: {
                return boundingBox.f_82291_ - hitX;
            }
            case NORTH: {
                return boundingBox.f_82291_ - hitX;
            }
            case SOUTH: {
                return hitX - boundingBox.f_82288_;
            }
            case WEST: {
                return hitZ - boundingBox.f_82290_;
            }
            case EAST: {
                return boundingBox.f_82293_ - hitZ;
            }
        }
        return 0.0;
    }

    private static double getHitV(Direction facing, AABB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case DOWN: {
                return boundingBox.f_82293_ - hitZ;
            }
            case UP: {
                return boundingBox.f_82293_ - hitZ;
            }
            case NORTH: {
                return boundingBox.f_82292_ - hitY;
            }
            case SOUTH: {
                return boundingBox.f_82292_ - hitY;
            }
            case WEST: {
                return boundingBox.f_82292_ - hitY;
            }
            case EAST: {
                return boundingBox.f_82292_ - hitY;
            }
        }
        return 0.0;
    }

    public static List<ItemStack> getLoot(ResourceLocation lootTable, Player player, InteractionHand hand, ServerLevel world, BlockState blockState) {
        LootTable table = world.m_142572_().m_129898_().m_79217_(lootTable);
        LootContext context = new LootContext.Builder(world).m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78972_(LootContextParams.f_81463_, (Object)player.m_21120_(hand)).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78975_(LootContextParamSets.f_81421_);
        return table.m_79129_(context);
    }

    public static List<ItemStack> getLoot(ResourceLocation lootTable, ServerLevel world, BlockPos pos, BlockState blockState) {
        LootTable table = world.m_142572_().m_129898_().m_79217_(lootTable);
        LootContext context = new LootContext.Builder(world).m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78975_(LootContextParamSets.f_81421_);
        return table.m_79129_(context);
    }

    public static void dropLoot(ResourceLocation lootTable, @Nullable Player player, @Nullable InteractionHand hand, ServerLevel world, BlockState blockState) {
        BlockInteraction.getLoot(lootTable, player, hand, world, blockState).forEach(itemStack -> {
            if (!player.m_150109_().m_36054_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
        });
    }

    public static void dropLoot(ResourceLocation lootTable, ServerLevel world, BlockPos pos, BlockState blockState) {
        BlockInteraction.getLoot(lootTable, world, pos, blockState).forEach(itemStack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)itemStack));
    }

    public boolean applicableForBlock(Level world, BlockPos pos, BlockState blockState) {
        return this.predicate.test(blockState);
    }

    public boolean isWithinBounds(double x, double y) {
        return (double)this.minX <= x && x <= (double)this.maxX && (double)this.minY <= y && y <= (double)this.maxY;
    }

    public boolean isPotentialInteraction(Level world, BlockPos pos, BlockState blockState, Direction hitFace, Collection<ToolAction> availableTools) {
        return this.isPotentialInteraction(world, pos, blockState, Direction.NORTH, hitFace, availableTools);
    }

    public boolean isPotentialInteraction(Level world, BlockPos pos, BlockState blockState, Direction blockFacing, Direction hitFace, Collection<ToolAction> availableTools) {
        return this.applicableForBlock(world, pos, blockState) && RotationHelper.rotationFromFacing((Direction)blockFacing).m_55954_(this.face).equals((Object)hitFace) && (this.alwaysReveal || availableTools.contains(this.requiredTool));
    }

    public void applyOutcome(Level world, BlockPos pos, BlockState blockState, @Nullable Player player, @Nullable InteractionHand hand, Direction hitFace) {
        this.outcome.apply(world, pos, blockState, player, hand, hitFace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInteraction that = (BlockInteraction)o;
        return this.requiredLevel == that.requiredLevel && Float.compare(that.minX, this.minX) == 0 && Float.compare(that.minY, this.minY) == 0 && Float.compare(that.maxX, this.maxX) == 0 && Float.compare(that.maxY, this.maxY) == 0 && Objects.equals(this.requiredTool, that.requiredTool) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.requiredTool, this.requiredLevel, this.face, Float.valueOf(this.minX), Float.valueOf(this.minY), Float.valueOf(this.maxX), Float.valueOf(this.maxY));
    }
}

