/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.scroll.ScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollTile;

@ParametersAreNonnullByDefault
public class RolledScrollBlock
extends ScrollBlock {
    public static final String identifier = "scroll_rolled";
    @ObjectHolder(value="tetra:scroll_rolled")
    public static ScrollBlock instance;
    private final VoxelShape[] baseShapes = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)9.0, (double)3.0, (double)15.0), Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)11.0, (double)3.0, (double)15.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape)Block.m_49796_((double)8.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0)), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0), Block.m_49796_((double)6.0, (double)6.0, (double)1.0, (double)9.0, (double)9.0, (double)15.0)})};
    private final Map<Direction, VoxelShape[]> shapes = new EnumMap<Direction, VoxelShape[]>(Direction.class);

    public RolledScrollBlock() {
        super(identifier, ScrollBlock.Arrangement.rolled);
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.m_122407_((int)i);
            VoxelShape[] result = new VoxelShape[this.baseShapes.length];
            for (int j = 0; j < result.length; ++j) {
                result[j] = RotationHelper.rotateDirection((VoxelShape)this.baseShapes[j], (Direction)direction);
            }
            this.shapes.put(direction, result);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int index = TileEntityOptional.from((BlockGetter)worldIn, (BlockPos)pos, ScrollTile.class).map(ScrollTile::getScrolls).map(scrolls -> ((ScrollData[])scrolls).length - 1).map(c -> Mth.m_14045_((int)c, (int)0, (int)5)).orElse(0);
        return this.shapes.get(facing)[index];
    }
}

