/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.ActionInteraction;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketCraft;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketTweak;
import se.mickelus.tetra.blocks.workbench.WorkbenchPacketUpdate;
import se.mickelus.tetra.blocks.workbench.action.ConfigAction;
import se.mickelus.tetra.blocks.workbench.action.RepairAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchAction;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchActionPacket;
import se.mickelus.tetra.craftingeffect.CraftingEffectRegistry;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class WorkbenchTile
extends BlockEntity
implements MenuProvider {
    public static final String unlocalizedName = "workbench";
    public static final int inventorySlots = 4;
    private static final String inventoryKey = "inv";
    private static final String currentSlotKey = "current_slot";
    private static final String schematicKey = "schematic";
    private static final WorkbenchAction[] defaultActions = new WorkbenchAction[]{new RepairAction()};
    @ObjectHolder(value="tetra:workbench")
    public static BlockEntityType<WorkbenchTile> type;
    @ObjectHolder(value="tetra:workbench")
    public static MenuType<WorkbenchContainer> containerType;
    private static WorkbenchAction[] actions;
    private final ItemStack previousTarget = ItemStack.f_41583_;
    private final Map<String, Runnable> changeListeners;
    private UpgradeSchematic currentSchematic;
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(this::createHandler);
    private String currentSlot;
    private ActionInteraction interaction;

    public WorkbenchTile(BlockPos p_155268_, BlockState p_155269_) {
        super(type, p_155268_, p_155269_);
        this.changeListeners = new HashMap<String, Runnable>();
    }

    public static void init(PacketHandler packetHandler) {
        packetHandler.registerPacket(WorkbenchPacketUpdate.class, WorkbenchPacketUpdate::new);
        packetHandler.registerPacket(WorkbenchPacketCraft.class, WorkbenchPacketCraft::new);
        packetHandler.registerPacket(WorkbenchActionPacket.class, WorkbenchActionPacket::new);
        packetHandler.registerPacket(WorkbenchPacketTweak.class, WorkbenchPacketTweak::new);
    }

    public static ItemStack consumeCraftingToolEffects(ItemStack upgradedStack, String slot, boolean isReplacing, ToolAction tool, int level, Player player, Level world, BlockPos pos, BlockState blockState, boolean consumeResources) {
        ItemStack providingStack = PropertyHelper.getPlayerProvidingItemStack(tool, level, (Entity)player);
        if (!providingStack.m_41619_()) {
            if (providingStack.m_41720_() instanceof IToolProvider) {
                upgradedStack = ((IToolProvider)providingStack.m_41720_()).onCraftConsume(providingStack, upgradedStack, player, tool, level, consumeResources);
            }
        } else {
            ItemStack toolbeltResult = PropertyHelper.consumeCraftToolToolbelt(player, upgradedStack, tool, level, consumeResources);
            if (toolbeltResult != null) {
                upgradedStack = toolbeltResult;
            } else {
                ItemStack consumeTarget = upgradedStack;
                upgradedStack = CastOptional.cast((Object)blockState.m_60734_(), AbstractWorkbenchBlock.class).map(block -> block.onCraftConsumeTool(world, pos, blockState, consumeTarget, slot, isReplacing, player, tool, level, consumeResources)).orElse(upgradedStack);
            }
        }
        return upgradedStack;
    }

    public static ItemStack applyCraftingBonusEffects(ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, ItemStack[] postMaterials, Map<ToolAction, Integer> tools, Level world, BlockPos pos, BlockState blockState, boolean consumeResources) {
        ItemStack result = upgradedStack.m_41777_();
        ResourceLocation[] unlockedEffects = CastOptional.cast((Object)blockState.m_60734_(), AbstractWorkbenchBlock.class).map(block -> block.getCraftingEffects(world, pos, blockState)).orElse(new ResourceLocation[0]);
        Arrays.stream(CraftingEffectRegistry.getEffects(unlockedEffects, upgradedStack, slot, isReplacing, player, preMaterials, tools, world, pos, blockState)).forEach(craftingEffect -> craftingEffect.applyOutcomes(result, slot, isReplacing, player, preMaterials, postMaterials, tools, world, pos, blockState, consumeResources));
        return result;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (slot == 0 && (itemStack.m_41619_() || !ItemStack.m_41728_((ItemStack)WorkbenchTile.this.getTargetItemStack(), (ItemStack)itemStack))) {
                    WorkbenchTile.this.currentSchematic = null;
                    WorkbenchTile.this.currentSlot = null;
                    WorkbenchTile.this.emptyMaterialSlots();
                }
                if (slot == 0) {
                    WorkbenchTile.this.interaction = ActionInteraction.create(WorkbenchTile.this);
                }
                WorkbenchTile.this.m_6596_();
                WorkbenchTile.this.f_58857_.m_7260_(WorkbenchTile.this.f_58858_, WorkbenchTile.this.m_58900_(), WorkbenchTile.this.m_58900_(), 3);
            }

            public int getSlots() {
                if (WorkbenchTile.this.currentSchematic != null) {
                    return WorkbenchTile.this.currentSchematic.getNumMaterialSlots() + 1;
                }
                return 1;
            }
        };
    }

    public WorkbenchAction[] getAvailableActions(Player player) {
        ItemStack itemStack = this.getTargetItemStack();
        return (WorkbenchAction[])Arrays.stream(actions).filter(action -> action.canPerformOn(player, this, itemStack)).toArray(WorkbenchAction[]::new);
    }

    public void performAction(Player player, String actionKey) {
        if (this.f_58857_.f_46443_) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new WorkbenchActionPacket(this.f_58858_, actionKey));
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(player, this, targetStack)).filter(action -> this.checkActionTools(player, (WorkbenchAction)action, targetStack)).ifPresent(action -> {
            action.getRequiredTools(targetStack).forEach((requiredTool, requiredLevel) -> {
                ItemStack providingStack = PropertyHelper.getPlayerProvidingItemStack(requiredTool, requiredLevel, (Entity)player);
                if (!providingStack.m_41619_()) {
                    if (providingStack.m_41720_() instanceof IToolProvider) {
                        ((IToolProvider)providingStack.m_41720_()).onActionConsume(providingStack, targetStack, player, (ToolAction)requiredTool, (int)requiredLevel, true);
                    }
                } else {
                    ItemStack toolbeltResult = PropertyHelper.consumeActionToolToolbelt(player, targetStack, requiredTool, requiredLevel, true);
                    if (toolbeltResult == null) {
                        CastOptional.cast((Object)this.m_58900_().m_60734_(), AbstractWorkbenchBlock.class).ifPresent(block -> block.onActionConsumeTool(this.f_58857_, this.m_58899_(), blockState, targetStack, player, (ToolAction)requiredTool, (int)requiredLevel, true));
                    }
                }
            });
            action.perform(player, targetStack, this);
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        });
    }

    public void performAction(String actionKey) {
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        ItemStack targetStack = this.getTargetItemStack();
        Arrays.stream(actions).filter(action -> action.getKey().equals(actionKey)).findFirst().filter(action -> action.canPerformOn(null, this, targetStack)).filter(action -> this.checkActionTools((WorkbenchAction)action, targetStack)).ifPresent(action -> {
            action.getRequiredTools(targetStack).forEach((requiredTool, requiredLevel) -> CastOptional.cast((Object)this.m_58900_().m_60734_(), AbstractWorkbenchBlock.class).ifPresent(block -> block.onActionConsumeTool(this.f_58857_, this.m_58899_(), blockState, targetStack, null, (ToolAction)requiredTool, (int)requiredLevel, true)));
            action.perform(null, targetStack, this);
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        });
    }

    private boolean checkActionTools(Player player, WorkbenchAction action, ItemStack itemStack) {
        return action.getRequiredTools(itemStack).entrySet().stream().allMatch(requirement -> PropertyHelper.getCombinedToolLevel(player, this.m_58904_(), this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), (ToolAction)requirement.getKey()) >= (Integer)requirement.getValue());
    }

    private boolean checkActionTools(WorkbenchAction action, ItemStack itemStack) {
        return action.getRequiredTools(itemStack).entrySet().stream().allMatch(requirement -> PropertyHelper.getBlockToolLevel(this.m_58904_(), this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), (ToolAction)requirement.getKey()) >= (Integer)requirement.getValue());
    }

    public BlockInteraction[] getInteractions() {
        if (this.interaction != null) {
            return new BlockInteraction[]{this.interaction};
        }
        return new BlockInteraction[0];
    }

    public UpgradeSchematic getCurrentSchematic() {
        return this.currentSchematic;
    }

    public void setCurrentSchematic(UpgradeSchematic schematic, String currentSlot) {
        this.currentSchematic = schematic;
        this.currentSlot = currentSlot;
        this.changeListeners.values().forEach(Runnable::run);
        this.sync();
    }

    public void clearSchematic() {
        this.setCurrentSchematic(null, null);
    }

    public void update(UpgradeSchematic currentSchematic, String currentSlot, Player player) {
        if (currentSchematic == null && player != null) {
            this.emptyMaterialSlots(player);
        }
        this.currentSchematic = currentSchematic;
        this.currentSlot = currentSlot;
        this.sync();
    }

    public String getCurrentSlot() {
        return this.currentSlot;
    }

    private void sync() {
        if (this.f_58857_.f_46443_) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new WorkbenchPacketUpdate(this.f_58858_, this.currentSchematic, this.currentSlot));
        } else {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public ItemStack getTargetItemStack() {
        return this.handler.map(handler -> {
            ItemStack stack = handler.getStackInSlot(0);
            ItemStack placeholder = ItemUpgradeRegistry.instance.getReplacement(stack);
            if (!placeholder.m_41619_()) {
                return placeholder;
            }
            return stack;
        }).orElse(ItemStack.f_41583_);
    }

    public boolean isTargetPlaceholder() {
        return this.handler.map(handler -> handler.getStackInSlot(0)).map(stack -> ItemUpgradeRegistry.instance.getReplacement((ItemStack)stack)).map(placeholder -> !placeholder.m_41619_()).orElse(false);
    }

    public ItemStack[] getMaterials() {
        return this.handler.map(handler -> {
            ItemStack[] result = new ItemStack[3];
            for (int i = 0; i < result.length; ++i) {
                result[i] = handler.getStackInSlot(i + 1).m_41777_();
            }
            return result;
        }).orElse(new ItemStack[0]);
    }

    public void initiateCrafting(Player player) {
        if (this.f_58857_.f_46443_) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new WorkbenchPacketCraft(this.f_58858_));
        }
        this.craft(player);
        this.sync();
    }

    public void craft(Player player) {
        ItemStack targetStack;
        ItemStack upgradedStack = targetStack = this.getTargetItemStack();
        IModularItem item = CastOptional.cast((Object)upgradedStack.m_41720_(), IModularItem.class).orElse(null);
        BlockState blockState = this.m_58900_();
        Map<ToolAction, Integer> availableTools = PropertyHelper.getCombinedToolLevels(player, this.m_58904_(), this.m_58899_(), blockState);
        ItemStack[] materials = this.getMaterials();
        ItemStack[] materialsAltered = (ItemStack[])Arrays.stream(this.getMaterials()).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
        if (item != null && this.currentSchematic != null && this.currentSchematic.canApplyUpgrade(player, targetStack, materialsAltered, this.currentSlot, availableTools)) {
            float severity = this.currentSchematic.getSeverity(targetStack, materialsAltered, this.currentSlot);
            boolean willReplace = this.currentSchematic.willReplace(targetStack, materialsAltered, this.currentSlot);
            if (willReplace) {
                TetraEnchantmentHelper.removeEnchantments(targetStack, this.currentSlot);
            }
            double durabilityFactor = upgradedStack.m_41763_() ? (double)upgradedStack.m_41773_() * 1.0 / (double)upgradedStack.m_41776_() : 0.0;
            double honingFactor = Mth.m_14008_((double)((double)item.getHoningProgress(upgradedStack) * 1.0 / (double)item.getHoningLimit(upgradedStack)), (double)0.0, (double)1.0);
            Map<ToolAction, Integer> tools = this.currentSchematic.getRequiredToolLevels(targetStack, materials);
            upgradedStack = this.currentSchematic.applyUpgrade(targetStack, materialsAltered, true, this.currentSlot, player);
            upgradedStack = WorkbenchTile.applyCraftingBonusEffects(upgradedStack, this.currentSlot, willReplace, player, materials, materialsAltered, tools, this.f_58857_, this.f_58858_, blockState, true);
            for (Map.Entry<ToolAction, Integer> entry : tools.entrySet()) {
                upgradedStack = WorkbenchTile.consumeCraftingToolEffects(upgradedStack, this.currentSlot, willReplace, entry.getKey(), entry.getValue(), player, this.f_58857_, this.f_58858_, blockState, true);
            }
            item.assemble(upgradedStack, this.f_58857_, severity);
            if (this.currentSchematic.isHoning()) {
                IModularItem.removeHoneable(upgradedStack);
            } else if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && !IModularItem.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (double)item.getHoningLimit(upgradedStack)));
            }
            if (upgradedStack.m_41763_() && !(this.currentSchematic instanceof RepairSchematic)) {
                if (durabilityFactor > 0.0 && willReplace && this.currentSlot.equals(item.getRepairSlot(upgradedStack))) {
                    item.repair(upgradedStack);
                } else {
                    upgradedStack.m_41721_((int)Math.ceil(durabilityFactor * (double)upgradedStack.m_41776_()));
                }
            }
            int xpCost = this.currentSchematic.getExperienceCost(targetStack, materials, this.currentSlot);
            if (!player.m_7500_() && xpCost > 0) {
                player.m_6749_(-xpCost);
            }
        }
        ItemStack tempStack = upgradedStack;
        this.handler.ifPresent(handler -> {
            for (int i = 0; i < materialsAltered.length; ++i) {
                handler.setStackInSlot(i + 1, materialsAltered[i]);
            }
            this.emptyMaterialSlots(player);
            handler.setStackInSlot(0, tempStack);
        });
        this.clearSchematic();
    }

    public ResourceLocation[] getUnlockedSchematics() {
        return CastOptional.cast((Object)this.m_58900_().m_60734_(), AbstractWorkbenchBlock.class).map(block -> block.getSchematics(this.f_58857_, this.f_58858_, this.m_58900_())).orElse(new ResourceLocation[0]);
    }

    public void applyTweaks(Player player, String slot, Map<String, Integer> tweaks) {
        if (this.f_58857_.f_46443_) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new WorkbenchPacketTweak(this.f_58858_, slot, tweaks));
        }
        this.tweak(player, slot, tweaks);
        this.sync();
    }

    public void tweak(Player player, String slot, Map<String, Integer> tweaks) {
        this.handler.ifPresent(handler -> {
            ItemStack tweakedStack = this.getTargetItemStack().m_41777_();
            CastOptional.cast((Object)tweakedStack.m_41720_(), IModularItem.class).ifPresent(item -> item.tweak(tweakedStack, slot, tweaks));
            handler.setStackInSlot(0, tweakedStack);
        });
    }

    public void addChangeListener(String key, Runnable runnable) {
        this.changeListeners.put(key, runnable);
    }

    public void removeChangeListener(String key) {
        this.changeListeners.remove(key);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_(inventoryKey)));
        String schematicKey = compound.m_128461_(schematicKey);
        this.currentSchematic = SchematicRegistry.getSchematic(schematicKey);
        if (compound.m_128441_(currentSlotKey)) {
            this.currentSlot = compound.m_128461_(currentSlotKey);
        }
        this.interaction = ActionInteraction.create(this);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.changeListeners.values().forEach(Runnable::run);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.handler.ifPresent(handler -> compound.m_128365_(inventoryKey, (Tag)handler.serializeNBT()));
        if (this.currentSchematic != null) {
            compound.m_128359_(schematicKey, this.currentSchematic.getKey());
        }
        if (this.currentSlot != null) {
            compound.m_128359_(currentSlotKey, this.currentSlot);
        }
    }

    private void emptyMaterialSlots(Player player) {
        this.handler.ifPresent(handler -> {
            for (int i = 1; i < handler.getSlots(); ++i) {
                this.transferStackToPlayer(player, i);
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        });
    }

    private void emptyMaterialSlots() {
        this.handler.ifPresent(handler -> {
            if (!this.f_58857_.f_46443_) {
                for (int i = 1; i < 4; ++i) {
                    ItemStack materialStack = handler.extractItem(i, handler.getSlotLimit(i), false);
                    if (materialStack.m_41619_()) continue;
                    ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.1, (double)this.f_58858_.m_123343_() + 0.5, materialStack);
                    itemEntity.m_32060_();
                    this.f_58857_.m_7967_((Entity)itemEntity);
                }
            } else {
                for (int i = 1; i < 4; ++i) {
                    handler.extractItem(i, handler.getSlotLimit(i), false);
                }
            }
        });
    }

    private void transferStackToPlayer(Player player, int index) {
        this.handler.ifPresent(handler -> {
            ItemStack itemStack = handler.extractItem(index, handler.getSlotLimit(index), false);
            if (!itemStack.m_41619_() && !player.m_150109_().m_36054_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
        });
    }

    public Component m_5446_() {
        return new TextComponent(unlocalizedName);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new WorkbenchContainer(windowId, this, (Container)playerInventory, playerEntity);
    }

    static {
        actions = new WorkbenchAction[0];
        DataManager.instance.actionData.onReload(() -> {
            Object[] configActions = (WorkbenchAction[])DataManager.instance.actionData.getData().values().stream().flatMap(Arrays::stream).toArray(ConfigAction[]::new);
            actions = (WorkbenchAction[])ArrayUtils.addAll((Object[])defaultActions, (Object[])configActions);
        });
    }
}

