/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.IModelConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.ModularItemModel;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.data.ModuleModel;

@ParametersAreNonnullByDefault
public class ModularOverrideList
extends ItemOverrides {
    private static final Logger logger = LogManager.getLogger();
    private final Cache<CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final ModularItemModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ResourceLocation modelLocation;

    public ModularOverrideList(ModularItemModel model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    public void clearCache() {
        logger.debug("Clearing item model cache for " + this.modelLocation);
        this.bakedModelCache.invalidateAll();
    }

    @Nullable
    public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int renderId) {
        CompoundTag baseTag = stack.m_41783_();
        BakedModel result = originalModel;
        if (baseTag != null && !baseTag.m_128456_()) {
            CacheKey key = this.getCacheKey(stack, entity, originalModel);
            try {
                result = (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, (Level)world, entity));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected BakedModel getOverrideModel(ItemStack itemStack, @Nullable Level world, @Nullable LivingEntity entity) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        ImmutableList<ModuleModel> models = item.getModels(itemStack, entity);
        String transformVariant = item.getTransformVariant(itemStack, entity);
        return this.model.realBake((List<ModuleModel>)models, transformVariant, this.owner, this.bakery, this.spriteGetter, this.modelTransform, ItemOverrides.f_111734_, this.modelLocation);
    }

    protected CacheKey getCacheKey(ItemStack itemStack, LivingEntity entity, BakedModel original) {
        return new CacheKey(original, ((IModularItem)itemStack.m_41720_()).getModelCacheKey(itemStack, entity));
    }

    protected static class CacheKey {
        final BakedModel parent;
        final String data;

        protected CacheKey(BakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

