/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class HauntedEffect {
    public static void perform(LivingEntity entity, ItemStack itemStack, double multiplier) {
        double effectProbability;
        if (!entity.f_19853_.f_46443_ && (effectProbability = EffectHelper.getEffectEfficiency(itemStack, ItemEffect.haunted)) > 0.0 && entity.m_21187_().nextDouble() < effectProbability * multiplier) {
            int effectLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.haunted);
            Vex vex = (Vex)EntityType.f_20491_.m_20615_(entity.f_19853_);
            vex.m_33987_(effectLevel * 20);
            vex.m_7678_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), entity.m_146908_(), 0.0f);
            vex.m_21008_(InteractionHand.MAIN_HAND, itemStack.m_41777_());
            vex.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            vex.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 2000 + effectLevel * 20));
            entity.f_19853_.m_7967_((Entity)vex);
            CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> Arrays.stream(item.getMajorModules(itemStack))).orElse(Stream.empty()).filter(Objects::nonNull).filter(module -> module.getImprovement(itemStack, "destabilized/haunted") != null).findAny().ifPresent(module -> {
                int level = module.getImprovementLevel(itemStack, "destabilized/haunted");
                if (level > 0) {
                    module.addImprovement(itemStack, "destabilized/haunted", level - 1);
                } else {
                    module.removeImprovement(itemStack, "destabilized/haunted");
                }
            });
            entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_12548_, SoundSource.PLAYERS, 2.0f, 2.0f);
        }
    }
}

