/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;

@ParametersAreNonnullByDefault
public class StatGetterEffectEfficiency
implements IStatGetter {
    private final ItemEffect effect;
    private final double multiplier;
    private final double base;

    public StatGetterEffectEfficiency(ItemEffect effect, double multiplier) {
        this(effect, multiplier, 0.0);
    }

    public StatGetterEffectEfficiency(ItemEffect effect, double multiplier, double base) {
        this.effect = effect;
        this.multiplier = multiplier;
        this.base = base;
    }

    @Override
    public double getValue(Player player, ItemStack itemStack) {
        return this.base + CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getEffectEfficiency(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> (double)module.getEffectEfficiency(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot, String improvement) {
        return this.base + CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).flatMap(item -> CastOptional.cast((Object)item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class)).map(module -> module.getImprovement(itemStack, improvement)).map(improvementData -> improvementData.effects).map(effects -> (double)effects.getEfficiency(this.effect) * this.multiplier).orElse(0.0);
    }
}

