/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ThrownModularItemRenderer
extends EntityRenderer<ThrownModularItemEntity> {
    public ThrownModularItemRenderer(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(ThrownModularItemEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLightIn) {
        matrixStack.m_85836_();
        Item item = entity.m_7941_().m_41720_();
        if (item instanceof ModularSingleHeadedItem) {
            this.transformSingleHeaded(entity, partialTicks, matrixStack);
        } else if (item instanceof ModularDoubleHeadedItem) {
            this.transformDoubleHeaded(entity, partialTicks, matrixStack);
        } else if (item instanceof ModularBladedItem) {
            this.transformBlade(entity, partialTicks, matrixStack);
        } else if (item instanceof ModularShieldItem) {
            this.transformShield(entity, partialTicks, matrixStack);
        }
        Minecraft.m_91087_().m_91291_().m_174269_(entity.m_7941_(), ItemTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, entity.m_142049_());
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, renderTypeBuffer, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ThrownModularItemEntity entity) {
        return null;
    }

    private void transformSingleHeaded(ThrownModularItemEntity entity, float partialTicks, PoseStack matrixStack) {
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.m_146908_()) - 90.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_()) + 135.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStack.m_85837_((double)0.3f, (double)-0.3f, 0.0);
    }

    private void transformDoubleHeaded(ThrownModularItemEntity entity, float partialTicks, PoseStack matrixStack) {
        if (entity.hasDealtDamage()) {
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_()) + 135.0f));
        } else {
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_()) + (float)entity.f_19797_ + partialTicks));
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.m_146908_()) - 90.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStack.m_85837_((double)0.3f, (double)-0.3f, 0.0);
    }

    private void transformBlade(ThrownModularItemEntity entity, float partialTicks, PoseStack matrixStack) {
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.m_146908_()) - 90.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_()) + 135.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
    }

    private void transformShield(ThrownModularItemEntity entity, float partialTicks, PoseStack matrixStack) {
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_())));
        if (entity.m_20096_()) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.m_146908_()) - 90.0f));
        } else {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.m_146908_()) + ((float)entity.f_19797_ + partialTicks) * 100.0f));
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(-0.2, 0.0, 0.0);
    }
}

