/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;

@ParametersAreNonnullByDefault
public class ModularSingleHeadedItem
extends ItemModularHandheld {
    public static final String headKey = "single/head";
    public static final String handleKey = "single/handle";
    public static final String bindingKey = "single/binding";
    private static final String unlocalizedName = "modular_single";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(1, -3, -11, 21);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(-14, 0);
    @ObjectHolder(value="tetra:modular_single")
    public static ModularSingleHeadedItem instance;

    public ModularSingleHeadedItem() {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.setRegistryName(unlocalizedName);
        this.entityHitDamage = 1;
        this.majorModuleKeys = new String[]{headKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headKey};
        this.updateConfig((Integer)ConfigHandler.honeSingleBase.get(), (Integer)ConfigHandler.honeSingleIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("single/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":throwing";
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return "throwing";
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

