/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.bow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.bow.ProjectileMotionPacket;
import se.mickelus.tetra.items.modular.impl.bow.RangedFOVTransformer;
import se.mickelus.tetra.items.modular.impl.bow.RangedProgressOverlay;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class ModularBowItem
extends ModularItem {
    public static final String staveKey = "bow/stave";
    public static final String stringKey = "bow/string";
    public static final String riserKey = "bow/riser";
    public static final String unlocalizedName = "modular_bow";
    public static final double velocityFactor = 0.125;
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(1, 21, -11, -3);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(-14, 23);
    @ObjectHolder(value="tetra:modular_bow")
    public static ModularBowItem instance;
    protected ModuleModel arrowModel0 = new ModuleModel("draw_0", new ResourceLocation("tetra", "items/module/bow/arrow_0"));
    protected ModuleModel arrowModel1 = new ModuleModel("draw_1", new ResourceLocation("tetra", "items/module/bow/arrow_1"));
    protected ModuleModel arrowModel2 = new ModuleModel("draw_2", new ResourceLocation("tetra", "items/module/bow/arrow_2"));
    protected ItemStack vanillaBow;

    public ModularBowItem() {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{stringKey, staveKey};
        this.minorModuleKeys = new String[]{riserKey};
        this.requiredModules = new String[]{stringKey, staveKey};
        this.vanillaBow = new ItemStack((ItemLike)Items.f_42411_);
        this.updateConfig((Integer)ConfigHandler.honeBowBase.get(), (Integer)ConfigHandler.honeBowIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    public static float getArrowVelocity(int charge, double strength, float velocityBonus, boolean suspend) {
        float velocity = (float)charge / 20.0f;
        if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
            velocity = 1.0f;
        }
        velocity *= (float)Math.max(1.0, 1.0 + (strength - 6.0) * 0.125);
        velocity = suspend && charge >= 20 ? (velocity *= 2.0f) : (velocity += velocity * velocityBonus);
        return velocity;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("bow/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new RangedProgressOverlay(Minecraft.m_91087_()));
        MinecraftForge.EVENT_BUS.register((Object)new RangedFOVTransformer());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> !((Attribute)entry.getKey()).equals(Attributes.f_22281_) && !((Attribute)entry.getKey()).equals(Attributes.f_22281_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity entity, int timeLeft) {
        if (this.getEffectLevel(itemStack, ItemEffect.overbowed) > 0 && timeLeft <= 0) {
            entity.m_5810_();
            CastOptional.cast((Object)entity, Player.class).ifPresent(player -> player.m_36335_().m_41524_((Item)this, 10));
        } else {
            this.fireArrow(itemStack, world, entity, timeLeft);
        }
    }

    public ItemStack m_5922_(ItemStack itemStack, Level world, LivingEntity entity) {
        if (this.getEffectLevel(itemStack, ItemEffect.overbowed) > 0) {
            entity.m_5810_();
            CastOptional.cast((Object)entity, Player.class).ifPresent(player -> player.m_36335_().m_41524_((Item)this, 10));
        }
        return super.m_5922_(itemStack, world, entity);
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int count) {
        if (this.getEffectLevel(itemStack, ItemEffect.releaseLatch) > 0 && this.getProgress(itemStack, player) >= 1.0f) {
            player.m_21253_();
        }
    }

    protected void fireArrow(ItemStack itemStack, Level world, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack ammoStack = player.m_6298_(this.vanillaBow);
            boolean playerInfinite = this.isInfinite(player, itemStack, ammoStack);
            int drawProgress = Math.round(this.getProgress(itemStack, entity) * 20.0f);
            if ((drawProgress = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (Level)world, (Player)player, (int)drawProgress, (!ammoStack.m_41619_() || playerInfinite ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.m_41619_() || playerInfinite) {
                int suspendLevel;
                float velocityBonus;
                double strength;
                float projectileVelocity;
                if (ammoStack.m_41619_()) {
                    ammoStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if ((projectileVelocity = ModularBowItem.getArrowVelocity(drawProgress, strength = this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawStrength.get()), velocityBonus = (float)this.getEffectLevel(itemStack, ItemEffect.velocity) / 100.0f, (suspendLevel = this.getEffectLevel(itemStack, ItemEffect.suspend)) > 0)) > 0.1f) {
                    ArrowItem ammoItem = CastOptional.cast((Object)ammoStack.m_41720_(), ArrowItem.class).orElse((ArrowItem)Items.f_42412_);
                    boolean infiniteAmmo = player.m_150110_().f_35937_ || ammoItem.isInfinite(ammoStack, itemStack, player);
                    int count = Mth.m_14045_((int)this.getEffectLevel(itemStack, ItemEffect.multishot), (int)1, (int)(infiniteAmmo ? 64 : ammoStack.m_41613_()));
                    if (!world.f_46443_) {
                        double spread = this.getEffectEfficiency(itemStack, ItemEffect.multishot);
                        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemStack);
                        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemStack);
                        int flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemStack);
                        int piercingLevel = this.getEffectLevel(itemStack, ItemEffect.piercing) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
                        for (int i = 0; i < count; ++i) {
                            double yaw = (double)player.m_146908_() - spread * (double)(count - 1) / 2.0 + spread * (double)i;
                            AbstractArrow projectile = ammoItem.m_6394_(world, ammoStack, (LivingEntity)player);
                            projectile.m_37251_((Entity)player, player.m_146909_(), (float)yaw, 0.0f, projectileVelocity * 3.0f, 1.0f);
                            if (drawProgress >= 20) {
                                projectile.m_36762_(true);
                            }
                            projectile.m_36781_(projectile.m_36789_() - 2.0 + strength / 3.0);
                            if (powerLevel > 0) {
                                projectile.m_36781_(projectile.m_36789_() + (double)powerLevel * 0.5 + 0.5);
                            }
                            if (projectileVelocity > 1.0f) {
                                projectile.m_36781_(projectile.m_36789_() / (double)projectileVelocity);
                            }
                            if (punchLevel > 0) {
                                projectile.m_36735_(punchLevel);
                            }
                            if (flameLevel > 0) {
                                projectile.m_20254_(100);
                            }
                            if (piercingLevel > 0) {
                                projectile.m_36767_((byte)piercingLevel);
                            }
                            if (suspendLevel > 0 && drawProgress >= 20) {
                                projectile.m_20242_(true);
                            }
                            if (infiniteAmmo || player.m_150110_().f_35937_ && (ammoStack.m_41720_() == Items.f_42737_ || ammoStack.m_41720_() == Items.f_42738_)) {
                                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            }
                            if (suspendLevel > 0 && drawProgress >= 20) {
                                Vec3 projDir = projectile.m_20184_().m_82541_();
                                Vec3 projPos = projectile.m_20182_();
                                for (int j = 0; j < 4; ++j) {
                                    Vec3 pos = projPos.m_82549_(projDir.m_82490_((double)(2 + j * 2)));
                                    ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.01);
                                }
                            }
                            world.m_7967_((Entity)projectile);
                            if (!(projectileVelocity * 3.0f > 4.0f)) continue;
                            TetraMod.packetHandler.sendToAllPlayersNear((AbstractPacket)new ProjectileMotionPacket((Projectile)projectile), projectile.m_142538_(), 512.0, world.m_46472_());
                        }
                        this.applyDamage(1, itemStack, (LivingEntity)player);
                        this.applyNegativeUsageEffects(entity, itemStack, 1.0);
                        if (drawProgress > 15) {
                            this.applyPositiveUsageEffects(entity, itemStack, 1.0);
                        }
                    }
                    float pitchBase = projectileVelocity;
                    if (velocityBonus > 0.0f) {
                        pitchBase -= pitchBase * velocityBonus;
                    } else if (suspendLevel > 0) {
                        pitchBase /= 2.0f;
                    }
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 0.8f + projectileVelocity * 0.2f, 1.9f + world.f_46441_.nextFloat() * 0.2f - pitchBase * 0.8f);
                    if (!infiniteAmmo && !player.m_150110_().f_35937_) {
                        ammoStack.m_41774_(count);
                        if (ammoStack.m_41619_()) {
                            player.m_150109_().m_36057_(ammoStack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    private boolean isInfinite(Player player, ItemStack bowStack, ItemStack ammoStack) {
        return player.m_150110_().f_35937_ || ammoStack.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bowStack) > 0 || CastOptional.cast((Object)ammoStack.m_41720_(), ArrowItem.class).map(item -> item.isInfinite(ammoStack, bowStack, player)).orElse(false) != false;
    }

    public int getDrawDuration(ItemStack itemStack) {
        return Math.max((int)(20.0 * (this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawSpeed.get()) - (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack) * 0.2)), 1);
    }

    public float getProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).filter(e -> e.m_21212_() > 0).filter(e -> itemStack.equals(e.m_21211_())).map(e -> Float.valueOf((float)(this.m_8105_(itemStack) - e.m_21212_()) * 1.0f / (float)this.getDrawDuration(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getOverbowProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        int overbowedLevel = this.getEffectLevel(itemStack, ItemEffect.overbowed);
        if (overbowedLevel > 0) {
            return Optional.ofNullable(entity).filter(e -> itemStack.equals(e.m_21211_())).map(LivingEntity::m_21212_).map(useCount -> Float.valueOf(1.0f - (float)useCount.intValue() / ((float)overbowedLevel * 2.0f))).map(progress -> Float.valueOf(Mth.m_14036_((float)progress.floatValue(), (float)0.0f, (float)1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public int m_8105_(ItemStack itemStack) {
        int overbowedLevel = this.getEffectLevel(itemStack, ItemEffect.overbowed);
        if (overbowedLevel > 0) {
            return overbowedLevel * 2 + this.getDrawDuration(itemStack);
        }
        return 37000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_41465_() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean hasAmmo;
        ItemStack bowStack = player.m_21120_(hand);
        boolean bl = hasAmmo = !player.m_6298_(this.vanillaBow).m_41619_();
        if (this.isBroken(bowStack)) {
            return InteractionResultHolder.m_19098_((Object)bowStack);
        }
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)bowStack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!hasAmmo && !player.m_150110_().f_35937_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bowStack) <= 0) {
            return InteractionResultHolder.m_19100_((Object)bowStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)bowStack);
    }

    private String getDrawVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        float progress = this.getProgress(itemStack, entity);
        if (progress == 0.0f) {
            return "item";
        }
        if ((double)progress < 0.65) {
            return "draw_0";
        }
        if ((double)progress < 0.9) {
            return "draw_1";
        }
        return "draw_2";
    }

    private ModuleModel getArrowModel(String drawVariant) {
        switch (drawVariant) {
            case "draw_0": {
                return this.arrowModel0;
            }
            case "draw_1": {
                return this.arrowModel1;
            }
            case "draw_2": {
                return this.arrowModel2;
            }
        }
        return this.arrowModel0;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return super.getModelCacheKey(itemStack, entity) + ":" + this.getDrawVariant(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        String modelType = this.getDrawVariant(itemStack, entity);
        ImmutableList models = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).filter(model -> model.type.equals(modelType) || model.type.equals("static")).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        if (!modelType.equals("item")) {
            return ImmutableList.builder().addAll((Iterable)models).add((Object)this.getArrowModel(modelType)).build();
        }
        return models;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

