/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuickslot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;

@ParametersAreNonnullByDefault
public class OverlayGuiQuickslotGroup
extends GuiElement {
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    private OverlayGuiQuickslot[] slots = new OverlayGuiQuickslot[0];

    public OverlayGuiQuickslotGroup(int x, int y) {
        super(x, y, 200, 0);
        this.isVisible = false;
        this.opacity = 0.0f;
        this.showAnimation = new KeyframeAnimation(200, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)(this.getX() + 10)), new Applier.Opacity(1.0f)}).onStop(isFinished -> {
            if (isFinished.booleanValue()) {
                Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(true));
            }
        });
        this.hideAnimation = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)this.getX()), new Applier.Opacity(0.0f)}).onStop(isFinished -> {
            if (isFinished.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void setInventory(QuickslotInventory inventory) {
        this.clearChildren();
        int numSlots = inventory.m_6643_();
        this.slots = new OverlayGuiQuickslot[numSlots];
        this.addChild((GuiElement)new GuiTexture(0, numSlots * -20 / 2 - 9, 22, 7, 0, 28, GuiTextures.toolbelt));
        this.addChild((GuiElement)new GuiTexture(0, numSlots * 20 / 2 + 2, 22, 7, 0, 35, GuiTextures.toolbelt));
        this.addChild((GuiElement)new GuiRect(0, numSlots * -20 / 2 - 2, 22, numSlots * 20 + 4, -872415232));
        for (int i = 0; i < numSlots; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            this.slots[i] = new OverlayGuiQuickslot(-35, numSlots * -20 / 2 + i * 20, itemStack, i);
            this.addChild(this.slots[i]);
        }
    }

    protected void onShow() {
        this.hideAnimation.stop();
        if (this.slots.length > 0) {
            this.showAnimation.start();
        }
    }

    protected boolean onHide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
        Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(false));
        return false;
    }

    public int getFocus() {
        return Arrays.stream(this.slots).filter(Objects::nonNull).filter(GuiElement::hasFocus).map(OverlayGuiQuickslot::getSlot).findFirst().orElse(-1);
    }

    public InteractionHand getHand() {
        return Arrays.stream(this.slots).filter(Objects::nonNull).filter(GuiElement::hasFocus).map(OverlayGuiQuickslot::getHand).findFirst().orElse(null);
    }
}

