/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.properties.IToolProvider;

@ParametersAreNonnullByDefault
public class FortuneBonusCondition
implements LootItemCondition {
    public static final ResourceLocation identifier = new ResourceLocation("tetra", "random_chance_with_fortune");
    public static final LootItemConditionType type = new LootItemConditionType((Serializer)new ConditionSerializer());
    private final int requiredToolLevel = -1;
    private float chance;
    private float fortuneMultiplier;
    private ToolAction requiredTool;

    public boolean test(LootContext context) {
        int fortuneLevel = 0;
        if (this.requiredTool != null) {
            ItemStack toolStack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (toolStack != null && toolStack.m_41720_() instanceof IToolProvider && ((IToolProvider)toolStack.m_41720_()).getToolLevel(toolStack, this.requiredTool) > -1) {
                fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)toolStack);
            }
        } else {
            ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (tool != null) {
                fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)((ItemStack)context.m_78953_(LootContextParams.f_81463_)));
            }
        }
        return context.m_78933_().nextFloat() < this.chance + (float)fortuneLevel * this.fortuneMultiplier;
    }

    public LootItemConditionType m_7940_() {
        return type;
    }

    public static class ConditionSerializer
    implements Serializer<FortuneBonusCondition> {
        public void serialize(JsonObject json, FortuneBonusCondition value, JsonSerializationContext context) {
            DataManager.gson.toJsonTree((Object)value).getAsJsonObject().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }

        public FortuneBonusCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return (FortuneBonusCondition)DataManager.gson.fromJson((JsonElement)json, FortuneBonusCondition.class);
        }
    }
}

