/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.TweakData;

@ParametersAreNonnullByDefault
public class MultiSlotModule
extends ItemModule {
    protected String slotSuffix;
    protected String unlocalizedName;

    public MultiSlotModule(ResourceLocation identifier, ModuleData data) {
        super(data.slots[0], identifier.m_135815_());
        this.slotSuffix = data.slotSuffixes[0];
        this.unlocalizedName = identifier.m_135815_().substring(0, identifier.m_135815_().length() - data.slotSuffixes[0].length());
        this.renderLayer = data.renderLayer;
        this.variantData = data.variants;
        if (data.tweakKey != null) {
            TweakData[] tweaks = (TweakData[])DataManager.instance.tweakData.getData(data.tweakKey);
            this.tweaks = tweaks != null ? tweaks : new TweakData[0];
        }
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public ModuleModel[] getModels(ItemStack itemStack) {
        return (ModuleModel[])Arrays.stream(super.getModels(itemStack)).map(model -> new ModuleModel(model.type, new ResourceLocation("tetra", model.location.m_135815_() + this.slotSuffix), model.tint)).toArray(ModuleModel[]::new);
    }
}

