/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;

@ParametersAreNonnullByDefault
public class OutcomeMaterial {
    private static final Logger logger = LogManager.getLogger();
    private static final JsonArray emptyArray = new JsonArray();
    public int count = 1;
    protected Collection<ItemStack> itemStacks = Collections.emptyList();
    protected ResourceLocation tagLocation;
    private ItemPredicate predicate;

    protected static TagCollection<Item> getTagCollection() {
        if (FMLEnvironment.dist.isClient() && Minecraft.m_91087_().f_91073_ != null) {
            return Minecraft.m_91087_().f_91073_.m_5999_().m_144452_(Registry.f_122904_);
        }
        return SerializationTags.m_13199_().m_144452_(Registry.f_122904_);
    }

    public OutcomeMaterial offsetCount(float multiplier, int offset) {
        OutcomeMaterial result = new OutcomeMaterial();
        result.count = Math.round((float)this.count * multiplier) + offset;
        result.itemStacks = this.itemStacks.stream().map(ItemStack::m_41777_).peek(result::setCount).collect(Collectors.toList());
        result.tagLocation = this.tagLocation;
        result.predicate = this.predicate;
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component[] getDisplayNames() {
        if (this.getPredicate() == null) {
            return new Component[]{new TextComponent("Unknown material")};
        }
        if (this.itemStacks != null) {
            return (Component[])this.itemStacks.stream().map(ItemStack::m_41786_).toArray(Component[]::new);
        }
        if (this.tagLocation != null) {
            return (Component[])OutcomeMaterial.getTagCollection().m_7689_(this.tagLocation).m_6497_().stream().map(item -> item.m_7626_(item.m_7968_())).toArray(Component[]::new);
        }
        return new Component[]{new TextComponent("Unknown material")};
    }

    public ItemStack[] getApplicableItemStacks() {
        if (this.getPredicate() == null) {
            return new ItemStack[0];
        }
        if (this.itemStacks != null && !this.itemStacks.isEmpty()) {
            return (ItemStack[])this.itemStacks.toArray(ItemStack[]::new);
        }
        if (this.tagLocation != null) {
            return (ItemStack[])OutcomeMaterial.getTagCollection().m_7689_(this.tagLocation).m_6497_().stream().map(Item::m_7968_).map(this::setCount).toArray(ItemStack[]::new);
        }
        return new ItemStack[0];
    }

    @Nullable
    public ItemPredicate getPredicate() {
        return this.predicate;
    }

    private ItemStack setCount(ItemStack itemStack) {
        itemStack.m_41764_(this.count);
        return itemStack;
    }

    public boolean isTagged() {
        return this.tagLocation != null;
    }

    public boolean isValid() {
        return this.predicate != null;
    }

    public static class Deserializer
    implements JsonDeserializer<OutcomeMaterial> {
        public OutcomeMaterial deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) {
            OutcomeMaterial material = new OutcomeMaterial();
            if (element != null && !element.isJsonNull()) {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)element, (String)"material");
                material.count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
                jsonObject.remove("count");
                if (jsonObject.has("items")) {
                    try {
                        material.itemStacks = StreamSupport.stream(GsonHelper.m_13832_((JsonObject)jsonObject, (String)"items", (JsonArray)emptyArray).spliterator(), false).map(jsonElement -> GsonHelper.m_13805_((JsonElement)jsonElement, (String)"item")).map(ResourceLocation::new).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).filter(Optional::isPresent).map(Optional::get).map(item -> new ItemStack((ItemLike)item, material.count)).collect(Collectors.toList());
                    }
                    catch (JsonSyntaxException e) {
                        material.itemStacks = Collections.emptyList();
                    }
                    if (!material.itemStacks.isEmpty() && jsonObject.has("nbt")) {
                        try {
                            CompoundTag compoundnbt = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)jsonObject.get("nbt"), (String)"nbt"));
                            material.itemStacks.forEach(itemStack -> itemStack.m_41751_(compoundnbt));
                        }
                        catch (CommandSyntaxException exception) {
                            throw new JsonSyntaxException("Encountered invalid nbt tag when parsing material: " + exception.getMessage());
                        }
                    }
                } else if (jsonObject.has("tag")) {
                    material.tagLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                }
                material.predicate = !jsonObject.has("type") && jsonObject.has("tag") ? this.deserializeTagPredicate(element) : ItemPredicateDeserializer.deserialize(element);
            }
            return material;
        }

        private ItemPredicate deserializeTagPredicate(@Nullable JsonElement element) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)element, (String)"item");
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
            Tag tag = OutcomeMaterial.getTagCollection().m_13404_(resourceLocation);
            if (tag == null) {
                logger.debug("Failed to parse outcome material predicate for \"{}\": Unknown tag '{}'", (Object)jsonObject.toString(), (Object)resourceLocation);
                return null;
            }
            MinMaxBounds.Ints count = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("count"));
            MinMaxBounds.Ints durability = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("durability"));
            EnchantmentPredicate[] enchantments = EnchantmentPredicate.m_30480_((JsonElement)jsonObject.get("enchantments"));
            EnchantmentPredicate[] storedEnchantments = EnchantmentPredicate.m_30480_((JsonElement)jsonObject.get("stored_enchantments"));
            NbtPredicate nbt = NbtPredicate.m_57481_((JsonElement)jsonObject.get("nbt"));
            return new ItemPredicate(tag, null, count, durability, enchantments, storedEnchantments, null, nbt);
        }
    }
}

