/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.MaterialMultiplier;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.SchematicRarity;
import se.mickelus.tetra.module.schematic.SchematicType;

public interface UpgradeSchematic {
    public String getKey();

    public String getName();

    public String getDescription(@Nullable ItemStack var1);

    @Nullable
    default public MaterialMultiplier getMaterialTranslation() {
        return null;
    }

    @Nullable
    default public String[] getApplicableMaterials() {
        return null;
    }

    public int getNumMaterialSlots();

    public String getSlotName(ItemStack var1, int var2);

    default public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return new ItemStack[0];
    }

    public int getRequiredQuantity(ItemStack var1, int var2, ItemStack var3);

    public boolean acceptsMaterial(ItemStack var1, String var2, int var3, ItemStack var4);

    public boolean isMaterialsValid(ItemStack var1, String var2, ItemStack[] var3);

    public boolean isApplicableForItem(ItemStack var1);

    public boolean isApplicableForSlot(String var1, ItemStack var2);

    default public boolean isVisibleForPlayer(Player player, @Nullable WorkbenchTile tile, ItemStack targetStack) {
        return true;
    }

    public boolean canApplyUpgrade(Player var1, ItemStack var2, ItemStack[] var3, String var4, Map<ToolAction, Integer> var5);

    public boolean isIntegrityViolation(Player var1, ItemStack var2, ItemStack[] var3, String var4);

    public ItemStack applyUpgrade(ItemStack var1, ItemStack[] var2, boolean var3, String var4, Player var5);

    public boolean checkTools(ItemStack var1, ItemStack[] var2, Map<ToolAction, Integer> var3);

    public Map<ToolAction, Integer> getRequiredToolLevels(ItemStack var1, ItemStack[] var2);

    default public Collection<ToolAction> getRequiredTools(ItemStack targetStack, ItemStack[] materials) {
        return this.getRequiredToolLevels(targetStack, materials).keySet();
    }

    default public int getRequiredToolLevel(ItemStack targetStack, ItemStack[] materials, ToolAction toolAction) {
        return this.getRequiredToolLevels(targetStack, materials).getOrDefault(toolAction, 0);
    }

    default public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        return 0;
    }

    default public boolean isHoning() {
        return false;
    }

    public SchematicType getType();

    default public SchematicRarity getRarity() {
        return SchematicRarity.basic;
    }

    public GlyphData getGlyph();

    public OutcomePreview[] getPreviews(ItemStack var1, String var2);

    default public float getSeverity(ItemStack itemStack, ItemStack[] materials, String slot) {
        return 1.0f;
    }

    default public boolean willReplace(ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }
}

