/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.world.BiomeModification;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmWorldGen
implements BalmWorldGen {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private static final List<BiomeModification> biomeModifications = new ArrayList<BiomeModification>();

    public ForgeBalmWorldGen() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(Supplier<T> supplier, ResourceLocation identifier) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.FEATURES, identifier.m_135827_());
        RegistryObject registryObject = register.register(identifier.m_135815_(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <T extends ConfiguredFeature<?, ?>> DeferredObject<T> registerConfiguredFeature(Supplier<T> supplier, ResourceLocation identifier) {
        DeferredObject<ConfiguredFeature> deferredObject = new DeferredObject<ConfiguredFeature>(identifier, () -> {
            ConfiguredFeature configuredFeature = (ConfiguredFeature)supplier.get();
            Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)identifier, (Object)configuredFeature);
            return configuredFeature;
        });
        this.getActiveRegistrations().configuredFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacedFeature> DeferredObject<T> registerPlacedFeature(Supplier<T> supplier, ResourceLocation identifier) {
        DeferredObject<PlacedFeature> deferredObject = new DeferredObject<PlacedFeature>(identifier, () -> {
            PlacedFeature placedFeature = (PlacedFeature)supplier.get();
            Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)identifier, (Object)placedFeature);
            return placedFeature;
        });
        this.getActiveRegistrations().placedFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(Supplier<T> supplier, ResourceLocation identifier) {
        return new DeferredObject<PlacementModifierType>(identifier, () -> {
            PlacementModifierType placementModifierType = (PlacementModifierType)supplier.get();
            Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)identifier, (Object)placementModifierType);
            return placementModifierType;
        }).resolveImmediately();
    }

    @Override
    public void addFeatureToBiomes(BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)placedFeatureIdentifier);
        biomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        for (BiomeModification biomeModification : biomeModifications) {
            PlacedFeature placedFeature;
            if (!biomeModification.getBiomePredicate().test(event.getName(), event.getCategory(), event.getClimate().f_47680_, event.getClimate().f_47681_, event.getClimate().f_47683_) || (placedFeature = (PlacedFeature)BuiltinRegistries.f_194653_.m_6246_(biomeModification.getConfiguredFeatureKey())) == null) continue;
            event.getGeneration().m_186664_(biomeModification.getStep(), placedFeature);
        }
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<DeferredObject<?>> configuredFeatures = new ArrayList();
        public final List<DeferredObject<?>> placedFeatures = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            this.configuredFeatures.forEach(DeferredObject::resolve);
            this.placedFeatures.forEach(DeferredObject::resolve);
        }
    }
}

