/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.mixin;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.starmun.justenoughkeys.common.contracts.IJEKKeyMappingExtensions;
import xyz.starmun.justenoughkeys.common.data.ModifierKey;
import xyz.starmun.justenoughkeys.common.data.ModifierKeyMap;

@Mixin(value={KeyMapping.class}, priority=999)
public class KeyMappingMixin
implements Comparable<KeyMapping>,
IJEKKeyMappingExtensions {
    @Shadow
    private InputConstants.Key f_90816_;
    @Shadow
    @Final
    private String f_90813_;
    @Shadow
    private int f_90818_;
    @Unique
    private final ModifierKeyMap modifierKeyMap = new ModifierKeyMap();
    @Unique
    private ModifierKeyMap defaultModifierKeyMap = new ModifierKeyMap();

    @Override
    public InputConstants.Key jek$getKey() {
        return this.f_90816_;
    }

    @Override
    public void jek$setClickCount(int i) {
        this.f_90818_ = i;
    }

    @Override
    public int jek$getClickCount() {
        return this.f_90818_;
    }

    @Override
    public ModifierKeyMap jek$getDefaultModifierKeyMap() {
        return this.defaultModifierKeyMap;
    }

    @Override
    public void setDefaultModifierKeyMap(ModifierKeyMap modifierKey) {
        this.defaultModifierKeyMap = modifierKey;
    }

    @Inject(method={"<init>(Ljava/lang/String;Lcom/mojang/blaze3d/platform/InputConstants$Type;ILjava/lang/String;)V"}, at={@At(value="TAIL")})
    public void fillMap(String string, InputConstants.Type type, int i, String string2, CallbackInfo ci) {
        IJEKKeyMappingExtensions.ALL.put(this.f_90813_, (KeyMapping)this);
        IJEKKeyMappingExtensions.initMAP((KeyMapping)this);
    }

    @Inject(method={"click"}, at={@At(value="HEAD")}, cancellable=true)
    private static void click(InputConstants.Key key, CallbackInfo ci) {
        IJEKKeyMappingExtensions.click(key);
        ci.cancel();
    }

    @Inject(method={"set"}, at={@At(value="HEAD")}, cancellable=true)
    private static void set(InputConstants.Key key, boolean pressed, CallbackInfo ci) {
        IJEKKeyMappingExtensions.set(key, pressed);
        ci.cancel();
    }

    @Inject(method={"getTranslatedKeyMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTranslatedKeyMessage(CallbackInfoReturnable<Component> cir) {
        TextComponent displayText = this.getModifiersText();
        displayText.m_7220_((Component)this.getKeyText());
        cir.setReturnValue((Object)displayText);
    }

    private TextComponent getKeyText() {
        TextComponent displayText = new TextComponent("");
        if (this.jek$getModifierKeyMap().any() && !ModifierKey.isModifierKey(this.jek$getKey())) {
            displayText.m_7220_((Component)new TextComponent("+"));
        }
        if (!this.jek$getModifierKeyMap().any() || !ModifierKey.isModifierKey(this.jek$getKey())) {
            displayText.m_7220_(this.jek$getKey().m_84875_());
        }
        return displayText;
    }

    private TextComponent getModifiersText() {
        TextComponent displayText = new TextComponent("");
        Splitter NAME_SPLITTER = Splitter.on((char)' ');
        Integer[] keyIndexes = this.jek$getModifierKeyMap().keySet().toArray(new Integer[0]);
        for (int i = 0; i < keyIndexes.length; ++i) {
            Iterator iterator = NAME_SPLITTER.split((CharSequence)ModifierKey.MODIFIER_KEYS.get(keyIndexes[i]).getDisplayName()).iterator();
            iterator.forEachRemaining(string -> displayText.m_130946_(string.substring(0, 1)));
            if (i == keyIndexes.length - 1) continue;
            displayText.m_7220_((Component)new TextComponent("+"));
        }
        return displayText;
    }

    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    public void matches(int i, int j, CallbackInfoReturnable<Boolean> cir) {
        if (!this.modifierKeyMap.any() && !IJEKKeyMappingExtensions.getMatchingKeyMappingsWithModifiers(InputConstants.m_84827_((int)i, (int)j)).isEmpty() || this.modifierKeyMap.any() && !this.modifierKeyMap.isPressed()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"matchesMouse"}, at={@At(value="HEAD")}, cancellable=true)
    public void matchesMouse(int i, CallbackInfoReturnable<Boolean> cir) {
        if (this.modifierKeyMap.any() && !this.modifierKeyMap.isPressed()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isDefault"}, at={@At(value="TAIL")}, cancellable=true)
    public void isDefault(CallbackInfoReturnable<Boolean> cir) {
        ModifierKeyMap modifierKeyMap = this.jek$getModifierKeyMap();
        ModifierKeyMap defaultModifierKeyMap = this.jek$getDefaultModifierKeyMap();
        if (modifierKeyMap.size() != defaultModifierKeyMap.size() || !modifierKeyMap.equals(defaultModifierKeyMap)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setAll"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setAll(CallbackInfo ci) {
        IJEKKeyMappingExtensions.setAll();
        ci.cancel();
    }

    @Inject(method={"releaseAll"}, at={@At(value="HEAD")}, cancellable=true)
    private static void releaseAll(CallbackInfo ci) {
        IJEKKeyMappingExtensions.releaseAll();
        ci.cancel();
    }

    @Override
    public ModifierKeyMap jek$getModifierKeyMap() {
        return this.modifierKeyMap;
    }

    @Override
    @Shadow
    public int compareTo(@NotNull KeyMapping o) {
        return 0;
    }
}

