/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.mixin;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.starmun.justenoughkeys.common.JustEnoughKeys;
import xyz.starmun.justenoughkeys.common.contracts.IJEKKeyMappingExtensions;
import xyz.starmun.justenoughkeys.common.data.ModifierKey;
import xyz.starmun.justenoughkeys.common.data.ModifierKeyMap;

@Mixin(value={Options.class})
public class OptionsMixin {
    @Unique
    private static File jekOptionsFile;
    @Final
    @Shadow
    public KeyMapping[] f_92059_;
    @Shadow
    @Final
    private static Splitter f_92107_;
    @Unique
    private static final Splitter VALUE_SPLITTER;

    @ModifyVariable(method={"<init>"}, at=@At(value="HEAD"), argsOnly=true)
    private static File init(File file) {
        jekOptionsFile = new File(file.getPath(), "options.justenoughkeys.txt");
        return file;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void load(CallbackInfo ci) {
        try {
            if (jekOptionsFile == null || !jekOptionsFile.exists()) {
                return;
            }
            try (BufferedReader bufferedReader = Files.newReader((File)jekOptionsFile, (Charset)Charsets.UTF_8);){
                bufferedReader.lines().forEach(line -> {
                    try {
                        Iterator lineIterator = f_92107_.split((CharSequence)line).iterator();
                        KeyMapping keyMapping = IJEKKeyMappingExtensions.ALL.get(((String)lineIterator.next()).replaceFirst("modifiers.", "").trim());
                        Iterator valueIterator = VALUE_SPLITTER.split((CharSequence)lineIterator.next()).iterator();
                        ModifierKeyMap modifierKeyMapOfCurrentKeyParse = new ModifierKeyMap();
                        valueIterator.forEachRemaining(keyValue -> {
                            if (keyValue.trim().length() > 0 && modifierKeyMapOfCurrentKeyParse.set(InputConstants.m_84851_((String)keyValue.trim())) == ModifierKey.UNKNOWN) {
                                JustEnoughKeys.LOGGER.error("Skipping option: {}, could not load.", line);
                            }
                        });
                        ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().set(modifierKeyMapOfCurrentKeyParse);
                    }
                    catch (Exception ex) {
                        JustEnoughKeys.LOGGER.error("Skipping option: {}, could not load.", line);
                    }
                });
            }
            catch (Exception ex) {
                JustEnoughKeys.LOGGER.error("Could not load Just Enough Keys options.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            JustEnoughKeys.LOGGER.error("Could not load Just Enough Keys options file", (Throwable)ex);
        }
        IJEKKeyMappingExtensions.resetMapping();
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void save(CallbackInfo ci) {
        try {
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jekOptionsFile), StandardCharsets.UTF_8));){
                for (KeyMapping keyMapping : this.f_92059_) {
                    StringBuilder builder = new StringBuilder();
                    ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().values().forEach(modifierKey -> builder.append(modifierKey.getName()).append(","));
                    printWriter.println("modifiers." + keyMapping.m_90860_() + ":" + (builder.length() > 0 ? builder.substring(0, builder.length() - 1) : ""));
                }
            }
            catch (Exception ex) {
                JustEnoughKeys.LOGGER.error("Failed to save Just Enough Keys options file", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            JustEnoughKeys.LOGGER.error("Failed to save Just Enough Keys options file", (Throwable)ex);
        }
    }

    static {
        VALUE_SPLITTER = Splitter.on((char)',');
    }
}

