/*
 * Decompiled with CFR 0.152.
 */
package com.exline.copperequipment;

import com.exline.copperequipment.CopperHoeItem;
import com.exline.copperequipment.ModArmorMaterial;
import com.exline.copperequipment.ModItemTier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"copperequipment");
    private static boolean isInitialised;
    public static final RegistryObject<Item> COPPER_NUGGET;
    public static final RegistryObject<SwordItem> COPPER_SWORD;
    public static final RegistryObject<ArmorItem> COPPER_HELM;
    public static final RegistryObject<ArmorItem> COPPER_CHEST;
    public static final RegistryObject<ArmorItem> COPPER_LEGGS;
    public static final RegistryObject<ArmorItem> COPPER_BOOTS;
    public static final RegistryObject<ShovelItem> COPPER_SHOVEL;
    public static final RegistryObject<PickaxeItem> COPPER_PICK;
    public static final RegistryObject<AxeItem> COPPER_AXE;
    public static final RegistryObject<CopperHoeItem> COPPER_HOE;
    public static final RegistryObject<HorseArmorItem> HORSE_ARMOR_COPPER;

    public static void register(IEventBus modEventBus) {
        if (isInitialised) {
            throw new IllegalStateException("Already initialised");
        }
        ITEMS.register(modEventBus);
        isInitialised = true;
    }

    private static Item.Properties defaultMiscProperties() {
        return new Item.Properties().m_41491_(CreativeModeTab.f_40753_);
    }

    private static Item.Properties defaultToolProperties() {
        return new Item.Properties().m_41491_(CreativeModeTab.f_40756_);
    }

    private static Item.Properties defaultCombatProperties() {
        return new Item.Properties().m_41491_(CreativeModeTab.f_40757_);
    }

    static {
        COPPER_NUGGET = ITEMS.register("copper_nugget", () -> new Item(ModItems.defaultMiscProperties()));
        COPPER_SWORD = ITEMS.register("copper_sword", () -> new SwordItem((Tier)ModItemTier.COPPER, 0, -2.4f, ModItems.defaultCombatProperties()));
        COPPER_HELM = ITEMS.register("copper_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterial.COPPER, EquipmentSlot.HEAD, ModItems.defaultCombatProperties()));
        COPPER_CHEST = ITEMS.register("copper_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterial.COPPER, EquipmentSlot.CHEST, ModItems.defaultCombatProperties()));
        COPPER_LEGGS = ITEMS.register("copper_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterial.COPPER, EquipmentSlot.LEGS, ModItems.defaultCombatProperties()));
        COPPER_BOOTS = ITEMS.register("copper_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterial.COPPER, EquipmentSlot.FEET, ModItems.defaultCombatProperties()));
        COPPER_SHOVEL = ITEMS.register("copper_shovel", () -> new ShovelItem((Tier)ModItemTier.COPPER, -1.5f, -3.0f, ModItems.defaultToolProperties()));
        COPPER_PICK = ITEMS.register("copper_pick", () -> new PickaxeItem((Tier)ModItemTier.COPPER, -2, -2.8f, ModItems.defaultToolProperties()));
        COPPER_AXE = ITEMS.register("copper_axe", () -> new AxeItem((Tier)ModItemTier.COPPER, 3.5f, -3.1f, ModItems.defaultToolProperties()));
        COPPER_HOE = ITEMS.register("copper_hoe", () -> new CopperHoeItem(ModItemTier.COPPER, -4.5f, -1.0f, ModItems.defaultToolProperties()));
        HORSE_ARMOR_COPPER = ITEMS.register("copper_horse_armor", () -> new HorseArmorItem(3, "copper", ModItems.defaultMiscProperties()));
    }
}

