/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.natives.compression;

import com.google.common.base.Preconditions;
import com.velocitypowered.natives.compression.CompressorUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.BufferPreference;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Java11VelocityCompressor
implements VelocityCompressor {
    public static final VelocityCompressorFactory FACTORY = Java11VelocityCompressor::new;
    private static final MethodHandle DEFLATE_SET_INPUT;
    private static final MethodHandle INFLATE_SET_INPUT;
    private static final MethodHandle DEFLATE_CALL;
    private static final MethodHandle INFLATE_CALL;
    private final Deflater deflater;
    private final Inflater inflater;
    private boolean disposed = false;

    private Java11VelocityCompressor(int level) {
        this.deflater = new Deflater(level);
        this.inflater = new Inflater();
    }

    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        this.ensureNotDisposed();
        Preconditions.checkArgument((source.nioBufferCount() == 1 ? 1 : 0) != 0, (Object)"source has multiple backing buffers");
        Preconditions.checkArgument((destination.nioBufferCount() == 1 ? 1 : 0) != 0, (Object)"destination has multiple backing buffers");
        try {
            int origIdx = source.readerIndex();
            INFLATE_SET_INPUT.invokeExact(this.inflater, source.nioBuffer());
            while (!this.inflater.finished() && this.inflater.getBytesRead() < (long)source.readableBytes()) {
                if (!destination.isWritable()) {
                    CompressorUtils.ensureMaxSize(destination, uncompressedSize);
                    destination.ensureWritable(8192);
                }
                ByteBuffer destNioBuf = destination.nioBuffer(destination.writerIndex(), destination.writableBytes());
                int produced = INFLATE_CALL.invokeExact(this.inflater, destNioBuf);
                source.readerIndex(origIdx + this.inflater.getTotalIn());
                destination.writerIndex(destination.writerIndex() + produced);
            }
            this.inflater.reset();
        }
        catch (Throwable e) {
            if (e instanceof DataFormatException) {
                throw (DataFormatException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deflate(ByteBuf source, ByteBuf destination) throws DataFormatException {
        this.ensureNotDisposed();
        Preconditions.checkArgument((source.nioBufferCount() == 1 ? 1 : 0) != 0, (Object)"source has multiple backing buffers");
        Preconditions.checkArgument((destination.nioBufferCount() == 1 ? 1 : 0) != 0, (Object)"destination has multiple backing buffers");
        try {
            int origIdx = source.readerIndex();
            DEFLATE_SET_INPUT.invokeExact(this.deflater, source.nioBuffer());
            this.deflater.finish();
            while (!this.deflater.finished()) {
                if (!destination.isWritable()) {
                    destination.ensureWritable(8192);
                }
                ByteBuffer destNioBuf = destination.nioBuffer(destination.writerIndex(), destination.writableBytes());
                int produced = DEFLATE_CALL.invokeExact(this.deflater, destNioBuf);
                source.readerIndex(origIdx + this.deflater.getTotalIn());
                destination.writerIndex(destination.writerIndex() + produced);
            }
            this.deflater.reset();
        }
        catch (Throwable e) {
            if (e instanceof DataFormatException) {
                throw (DataFormatException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.disposed = true;
        this.deflater.end();
        this.inflater.end();
    }

    private void ensureNotDisposed() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Object already disposed");
    }

    @Override
    public BufferPreference preferredBufferType() {
        return BufferPreference.DIRECT_PREFERRED;
    }

    static {
        try {
            DEFLATE_SET_INPUT = MethodHandles.lookup().findVirtual(Deflater.class, "setInput", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            INFLATE_SET_INPUT = MethodHandles.lookup().findVirtual(Inflater.class, "setInput", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            DEFLATE_CALL = MethodHandles.lookup().findVirtual(Deflater.class, "deflate", MethodType.methodType(Integer.TYPE, ByteBuffer.class));
            INFLATE_CALL = MethodHandles.lookup().findVirtual(Inflater.class, "inflate", MethodType.methodType(Integer.TYPE, ByteBuffer.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)"Can't use Java 11 compressor on your version of Java");
        }
    }
}

